/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.generalchecks;

import org.apache.felix.hc.annotation.HealthCheckService;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.core.impl.util.lang.StringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPolicy=ConfigurationPolicy.OPTIONAL)
@HealthCheckService(name="OSGi Framework Ready Check", tags={"systemalive"})
@Designate(ocd=Config.class)
public class FrameworkStartCheck
implements HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(FrameworkStartCheck.class);
    public static final String HC_NAME = "OSGi Framework Ready Check";
    public static final String HC_DEFAULT_TAG = "systemalive";
    public static final String PROP_START_LEVEL_BEGINNING = "org.osgi.framework.startlevel.beginning";
    private BundleContext bundleContext;
    private long targetStartLevel;
    private String beginningStartLevel;

    @Activate
    protected void activate(BundleContext ctx, Config config) throws InterruptedException {
        this.bundleContext = ctx;
        this.targetStartLevel = this.getTargetStartLevel(config);
        this.beginningStartLevel = this.getBeginningStartLevel();
        LOG.debug("Activated targetStartLevel={}, beginningStartLevel={}, ", (Object)this.targetStartLevel, (Object)this.beginningStartLevel);
    }

    private long getTargetStartLevel(Config config) {
        FrameworkStartLevel fsl = (FrameworkStartLevel)this.bundleContext.getBundle(0L).adapt(FrameworkStartLevel.class);
        long initial = fsl.getInitialBundleStartLevel();
        long tStartLevel = config.targetStartLevel() > 0 ? (long)config.targetStartLevel() : initial;
        String targetStartLevelKey = config.targetStartLevel_propName();
        if (null != targetStartLevelKey && !targetStartLevelKey.trim().isEmpty()) {
            try {
                tStartLevel = Long.valueOf(this.bundleContext.getProperty(targetStartLevelKey));
            }
            catch (NumberFormatException e) {
                LOG.info("Ignoring {} as it can't be parsed: {}", (Object)targetStartLevelKey, (Object)e.getMessage());
            }
        }
        return tStartLevel;
    }

    private String getBeginningStartLevel() {
        String beginningStartLevel = StringUtils.defaultIfBlank(this.bundleContext.getProperty(PROP_START_LEVEL_BEGINNING), "<unknown>");
        return beginningStartLevel;
    }

    public Result execute() {
        boolean started;
        Bundle systemBundle = this.bundleContext.getBundle(0L);
        FrameworkStartLevel fsl = (FrameworkStartLevel)systemBundle.adapt(FrameworkStartLevel.class);
        String message = String.format(" (state: %s) Current Start Level: %d (Target: %d; Beginning: %s)", this.stateToStr(fsl.getBundle().getState()), fsl.getStartLevel(), this.targetStartLevel, this.beginningStartLevel);
        boolean bl = started = systemBundle.getState() == 32 && (long)fsl.getStartLevel() >= this.targetStartLevel;
        if (started) {
            return new Result(Result.Status.OK, "Framework started" + message);
        }
        return new Result(Result.Status.TEMPORARILY_UNAVAILABLE, "Framework NOT started" + message);
    }

    private String stateToStr(int state) {
        switch (state) {
            case 32: {
                return "ACTIVE";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 1: {
                return "UNINSTALLED";
            }
        }
        return "unknown";
    }

    @ObjectClassDefinition(name="Health Check: OSGi Framework Ready Check", description="System ready that waits for the system bundle to be active")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="Name of this health check")
        public String hc_name() default "OSGi Framework Ready Check";

        @AttributeDefinition(name="Tags", description="List of tags for this health check, used to select subsets of health checks for execution e.g. by a composite health check.")
        public String[] hc_tags() default {"systemalive"};

        @AttributeDefinition(name="Target start level", description="The target start level at which the Framework is considered started. If zero or negative, it will default to the default bundle start level")
        public int targetStartLevel() default 0;

        @AttributeDefinition(name="Target start level OSGi property name", description="The name of the OSGi property which holds the \"Target start level\". It takes precedence over the 'targetStartLevel' config. If the startlevel cannot be derived from the osgi property, this config attribute is ignored.")
        public String targetStartLevel_propName() default "";
    }
}

