/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.utils.core;

import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.felix.atomos.utils.api.Context;
import org.apache.felix.atomos.utils.api.FileType;
import org.apache.felix.atomos.utils.api.RegisterServiceCall;
import org.apache.felix.atomos.utils.substrate.api.dynproxy.DynamicProxyConfiguration;
import org.apache.felix.atomos.utils.substrate.api.reflect.ReflectionConfiguration;
import org.apache.felix.atomos.utils.substrate.api.resource.ResourceConfiguration;
import org.apache.felix.atomos.utils.substrate.impl.config.DefaultDynamicProxyConfiguration;
import org.apache.felix.atomos.utils.substrate.impl.config.DefaultReflectionClassConfiguration;
import org.apache.felix.atomos.utils.substrate.impl.config.DefaultReflectionConfiguration;
import org.apache.felix.atomos.utils.substrate.impl.config.DefaultReflectionConstructorConfiguration;
import org.apache.felix.atomos.utils.substrate.impl.config.DefaultReflectionFieldConfiguration;
import org.apache.felix.atomos.utils.substrate.impl.config.DefaultReflectionMethodConfiguration;
import org.apache.felix.atomos.utils.substrate.impl.config.DefaultResourceConfiguration;

public class ContextImpl
implements Context {
    private final Map<Path, FileType> paths = new HashMap<Path, FileType>();
    private final Collection<DefaultReflectionClassConfiguration> reflectConfigs = new ArrayList<DefaultReflectionClassConfiguration>();
    private final List<RegisterServiceCall> registerServiceCalls = new ArrayList<RegisterServiceCall>();
    private final DefaultResourceConfiguration resourceConfig = new DefaultResourceConfiguration();
    private final DefaultDynamicProxyConfiguration dynamicProxyConfigs = new DefaultDynamicProxyConfiguration();

    public void addDynamicProxyConfigs(String ... items) {
        this.dynamicProxyConfigs.addItem(items);
    }

    public void addFile(Path path, FileType type) {
        this.paths.put(path, type);
    }

    public void addReflecionMethod(String mName, Class<?>[] parameterTypes, Class<?> clazz) {
        Class<?> superClass;
        for (Method m : clazz.getDeclaredMethods()) {
            if (!mName.equals(m.getName())) continue;
            if (parameterTypes == null) {
                DefaultReflectionClassConfiguration config = this.computeIfAbsent(clazz.getName());
                config.add(new DefaultReflectionMethodConfiguration(mName, null));
                break;
            }
            if (!Arrays.equals(m.getParameterTypes(), parameterTypes)) continue;
            DefaultReflectionClassConfiguration config = this.computeIfAbsent(clazz.getName());
            String[] sParameterTypes = (String[])((Stream)Stream.of(parameterTypes).sequential()).map(Class::getName).toArray(String[]::new);
            config.add(new DefaultReflectionMethodConfiguration(mName, sParameterTypes));
            break;
        }
        if ((superClass = clazz.getSuperclass()) != null) {
            this.addReflecionMethod(mName, parameterTypes, superClass);
        }
    }

    public void addReflectionClass(String className) {
        this.computeIfAbsent(className);
    }

    public void addReflectionConstructor(String bundleActivatorClassName, String[] parameterTypeNames) {
        this.computeIfAbsent(bundleActivatorClassName).add(new DefaultReflectionConstructorConfiguration(parameterTypeNames));
    }

    public void addReflectionConstructorAllPublic(String clazzName) {
        this.computeIfAbsent(clazzName).setAllPublicConstructors(true);
    }

    public void addReflectionField(String fName, Class<?> clazz) {
        Class<?> superClass;
        boolean exists = Stream.of(clazz.getDeclaredFields()).anyMatch(f -> f.getName().equals(fName));
        if (exists) {
            DefaultReflectionClassConfiguration config = this.computeIfAbsent(clazz.getName());
            config.add(new DefaultReflectionFieldConfiguration(fName));
        }
        if ((superClass = clazz.getSuperclass()) != null) {
            this.addReflectionField(fName, superClass);
        }
    }

    public void addReflectionFieldsAllPublic(String className) {
        this.computeIfAbsent(className).setAllPublicFields(true);
    }

    public void addReflectionMethodsAllPublic(String className) {
        this.computeIfAbsent(className).setAllPublicMethods(true);
    }

    public void addRegisterServiceCalls(RegisterServiceCall registerServiceCall) {
        this.registerServiceCalls.add(registerServiceCall);
    }

    public void addResourceConfig(ResourceConfiguration resourceConfig) {
        this.resourceConfig.addResourcePackage((Collection)resourceConfig.getResourcePackages());
        this.resourceConfig.addResourcePattern((Collection)resourceConfig.getResourcePatterns());
        this.resourceConfig.addResourceBundle((Collection)resourceConfig.getResourceBundles());
    }

    private DefaultReflectionClassConfiguration computeIfAbsent(String className) {
        Optional<DefaultReflectionClassConfiguration> oConfig = this.reflectConfigs.stream().filter(c -> c.getClassName().equals(className)).findFirst();
        DefaultReflectionClassConfiguration rc = null;
        if (oConfig.isPresent()) {
            rc = oConfig.get();
        } else {
            rc = new DefaultReflectionClassConfiguration(className);
            this.reflectConfigs.add(rc);
        }
        return rc;
    }

    public DynamicProxyConfiguration getDynamicProxyConfig() {
        return this.dynamicProxyConfigs;
    }

    public Stream<Path> getFiles(FileType ... fileType) {
        return this.paths.entrySet().stream().filter(e -> List.of(fileType).stream().filter(Objects::nonNull).anyMatch(t -> t.equals(e.getValue()))).map(Map.Entry::getKey);
    }

    Map<Path, FileType> getPaths() {
        return Map.copyOf(this.paths);
    }

    public ReflectionConfiguration getReflectConfig() {
        return new DefaultReflectionConfiguration(List.copyOf(this.reflectConfigs));
    }

    public List<RegisterServiceCall> getRegisterServiceCalls() {
        return this.registerServiceCalls;
    }

    public ResourceConfiguration getResourceConfig() {
        return this.resourceConfig;
    }
}

