/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.dubbo.apidocs.core;

/**
 * constants.
 *
 * @date 2021/2/3 10:19
 */
public class Constants {

    public static final String DOT = ".";

    /**
     * Method parameter index left boundary.
     */
    public static final String METHOD_PARAM_INDEX_BOUNDARY_LEFT = "[";

    /**
     * Method parameter index right boundary.
     */
    public static final String METHOD_PARAM_INDEX_BOUNDARY_RIGHT = "]";

    /**
     * Method parameter separator.
     */
    public static final String METHOD_PARAMETER_SEPARATOR = " | ";

    /**
     * To skip when processing fields: serialVersionUID.
     */
    public static final String SKIP_FIELD_SERIALVERSIONUID = "serialVersionUID";

    /**
     * To skip when processing fields: this$0.
     */
    public static final String SKIP_FIELD_THIS$0 = "this$0";

    public static final String CLASS_FIELD_NAME = "class";

    /**
     * Allowed value of drop-down selection box: true.
     */
    public static final String ALLOWABLE_BOOLEAN_TRUE = "true";

    /**
     * Allowed value of drop-down selection box: false.
     */
    public static final String ALLOWABLE_BOOLEAN_FALSE = "false";

    /**
     * Enumerating the name method in a type.
     */
    public static final String METHOD_NAME_NAME = "name";

    public static final String SQUARE_BRACKET_LEFT = "【";

    public static final String SQUARE_BRACKET_RIGHT = "】";

    public static final String RESPONSE_STR_EXAMPLE = "example: ";

    public static final String ENUM_VALUES_SEPARATOR = "|";

    public static final Object EMPTY_OBJECT_INSTANCE = new Object();

    public static final String STRING_EMPTY = "";

    public static final String STRING_KEY = "key";

    public static final String NO_ARGS_NO_RETURN_VALUES_METHOD_DESC = "()V";

}
