/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.util.StringTokenizer;

public class JavaVersionHolder {
    private static final String EARLY_ACCESS_SUFFIX = "-ea";
    private String majorVersion;
    private String minorVersion;
    private int major;
    private int minor;

    public JavaVersionHolder(String javaVersion) throws NumberFormatException {
        javaVersion = this.stripEarlyAccessSuffix((String)javaVersion);
        if (((String)javaVersion).startsWith("9")) {
            javaVersion = "1.9.0";
        }
        if (((String)javaVersion).startsWith("11")) {
            javaVersion = "1.11.0";
        }
        switch (javaVersion) {
            case "10": 
            case "13": 
            case "14": 
            case "15": 
            case "16": 
            case "17": 
            case "18": 
            case "19": 
            case "20": 
            case "21": {
                javaVersion = "1." + (String)javaVersion + ".0";
                break;
            }
        }
        int i = ((String)javaVersion).indexOf(46);
        int j = ((String)javaVersion).indexOf(46, i + 1);
        this.majorVersion = ((String)javaVersion).substring(0, i);
        try {
            Integer imajor = Integer.valueOf(this.majorVersion);
            this.major = imajor;
            if (j != -1) {
                this.minorVersion = ((String)javaVersion).substring(i + 1, j);
                Integer iminor = Integer.valueOf(this.minorVersion);
                this.minor = iminor;
            } else {
                this.minorVersion = ((String)javaVersion).substring(i + 1);
                Integer iminor = Integer.valueOf(this.minorVersion);
                this.minor = iminor;
            }
        }
        catch (NumberFormatException nfe) {
            if (((String)javaVersion).startsWith("HP")) {
                StringTokenizer st = new StringTokenizer((String)javaVersion, ".");
                String tmp = st.nextToken();
                this.majorVersion = st.nextToken();
                if (this.majorVersion.equals("01")) {
                    this.majorVersion = "1";
                } else if (this.majorVersion.equals("02")) {
                    this.majorVersion = "2";
                }
                this.minorVersion = st.nextToken();
                if (this.minorVersion.startsWith("1")) {
                    this.minorVersion = "1";
                } else if (this.minorVersion.startsWith("2")) {
                    this.minorVersion = "2";
                }
                try {
                    Integer imajor = Integer.valueOf(this.majorVersion);
                    this.major = imajor;
                    Integer iminor = Integer.valueOf(this.minorVersion);
                    this.minor = iminor;
                }
                catch (NumberFormatException nfe2) {
                    System.out.println("Could not parse version: " + String.valueOf(nfe2));
                }
            }
            System.out.println("NumberFormatException thrown trying to parse the version. " + (String)javaVersion);
            System.out.println("The test harness only handles the HP special case.");
        }
    }

    private String stripEarlyAccessSuffix(String javaVersion) {
        int suffixIndex = javaVersion.indexOf(EARLY_ACCESS_SUFFIX);
        if (suffixIndex < 0) {
            return javaVersion;
        }
        return javaVersion.substring(0, suffixIndex);
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public String getMinorVersion() {
        return this.minorVersion;
    }

    public int getMajorNumber() {
        return this.major;
    }

    public int getMinorNumber() {
        return this.minor;
    }

    public boolean atLeast(int baseMajor, int baseMinor) {
        if (this.major < baseMajor) {
            return false;
        }
        if (this.major > baseMajor) {
            return true;
        }
        return this.minor >= baseMinor;
    }
}

