/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Locale;
import junit.framework.Test;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.optional.api.LuceneIndexDescriptor;
import org.apache.derby.optional.api.LuceneUtils;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.functionTests.tests.lang.Permission;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.LocaleTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;

public class LuceneSupportPermsTest
extends GeneratedColumnsHelper {
    private static final String LUCENE_VERSION_PROPERTY = "derby.tests.lucene.version";
    private static String LUCENE_VERSION = "LUCENE_47";
    private static final String DB_NAME = "lucenesupportpermsdb";
    private static final String TEST_DBO = "TEST_DBO";
    private static final String RUTH = "RUTH";
    private static final String ALICE = "ALICE";
    private static final String FRANK = "FRANK";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "ALICE", "RUTH", "FRANK"};
    private static final String AUTH_NO_ACCESS_NOT_OWNER = "42507";
    private static final String DBO_ONLY = "4251D";
    private static final String FUNCTION_EXISTS = "X0Y68";
    private static final String NOT_INDEXABLE = "42XBA";
    private static final String NO_PRIMARY_KEY = "42XBB";
    private static final String NONEXISTENT_INDEX = "42XBE";
    private static final String NO_DDL_PRIV = "42XBF";
    private static final String DOUBLE_LOAD_ILLEGAL = "42XBG";
    private static final String DOUBLE_UNLOAD_ILLEGAL = "42XBH";
    private static final String BAD_DIRECTORY = "42XBI";
    private static final String BAD_COLUMN_NAME = "42XBJ";
    private static final String NONEXISTENT_TABLE_FUNCTION = "42ZB4";
    private static final String INCOMPATIBLE_ENCRYPTION = "42XBL";
    private static final String ILLEGAL_NULL_ARG = "42XBM";
    private static final String BAD_FIELD_NAME = "42XBN";
    private static final String DUPLICATE_FIELD_NAME = "42XBO";
    private static final String NULL_PRIMITIVE_ARG = "39004";
    private static final String POLICY_FILE = "org/apache/derbyTesting/functionTests/tests/lang/luceneSupport.policy";
    private static final String LOAD_TOOL = "call syscs_util.syscs_register_tool( 'luceneSupport', true )";
    private static final String UNLOAD_TOOL = "call syscs_util.syscs_register_tool( 'luceneSupport', false )";
    private static final String INDEX_POEMS = "call LuceneSupport.createIndex( 'ruth', 'poems', 'poemText', null )";
    private static final String UPDATE_POEMS_INDEX = "call LuceneSupport.updateIndex( 'ruth', 'poems', 'poemText', null )";
    private static final String DROP_POEMS_INDEX = "call LuceneSupport.dropIndex( 'ruth', 'poems', 'poemText' )";
    private static final String DROP_PRIMARY_KEY = "alter table poems drop constraint poemsKey";
    private static final long MILLIS_IN_HOUR = 3600000L;
    private static final long MILLIS_IN_DAY = 86400000L;
    private static final String LANGUAGE = "en";
    private static final String COUNTRY = "US";
    private static final String DEFAULT_INDEX_DESCRIPTOR = "org.apache.derby.optional.api.LuceneUtils.defaultIndexDescriptor";
    private static final String CONSTANT_QUERY_PARSER = "org.apache.derbyTesting.functionTests.tests.lang.LuceneSupportPermsTest.constantStringIndexDescriptor";
    static String[] _fieldNames;

    public LuceneSupportPermsTest(String name) {
        super(name);
    }

    public static Test suite() {
        String luceneVersion = LuceneSupportPermsTest.getSystemProperty(LUCENE_VERSION_PROPERTY);
        if (luceneVersion != null) {
            LUCENE_VERSION = luceneVersion;
        }
        BaseTestSuite suite = (BaseTestSuite)TestConfiguration.embeddedSuite(LuceneSupportPermsTest.class);
        SecurityManagerSetup secureTest = new SecurityManagerSetup((Test)suite, POLICY_FILE);
        Test authenticatedTest = DatabasePropertyTestSetup.builtinAuthentication((Test)secureTest, LEGAL_USERS, "LuceneSupportPermissions");
        Test authorizedTest = TestConfiguration.sqlAuthorizationDecoratorSingleUse(authenticatedTest, DB_NAME, true);
        LocaleTestSetup localizedTest = new LocaleTestSetup(authorizedTest, new Locale(LANGUAGE, COUNTRY));
        return localizedTest;
    }

    public void test_001_basicNoGrant() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        Connection aliceConnection = this.openUserConnection(ALICE);
        this.createSchema(ruthConnection, 4);
        this.expectExecutionError(ruthConnection, "42504", LOAD_TOOL);
        this.goodStatement(dboConnection, LOAD_TOOL);
        this.expectExecutionError(ruthConnection, NONEXISTENT_INDEX, UPDATE_POEMS_INDEX);
        this.expectExecutionError(aliceConnection, "42502", INDEX_POEMS);
        this.goodStatement(ruthConnection, INDEX_POEMS);
        this.expectExecutionError(ruthConnection, FUNCTION_EXISTS, INDEX_POEMS);
        this.expectExecutionError(ruthConnection, NONEXISTENT_INDEX, "call LuceneSupport.updateIndex( 'ruth', 'poems', 'foo', null )");
        this.expectExecutionError(ruthConnection, NONEXISTENT_INDEX, "call LuceneSupport.updateIndex( 'ruth', 'poems', 'originalAuthor', null )");
        String viewPoemsIndex = "select * from table ( ruth.poems__poemText( 'star', 1000, null ) ) luceneResults order by poemID";
        this.expectExecutionError(aliceConnection, "42504", viewPoemsIndex);
        this.assertResults(ruthConnection, viewPoemsIndex, new String[][]{{"3", "3", "2", "0.22933942"}, {"4", "4", "3", "0.22933942"}, {"5", "5", "4", "0.26756266"}}, false);
        String listIndexes = "select schemaName, tableName, columnName from table ( LuceneSupport.listIndexes() ) listindexes";
        this.assertResults(aliceConnection, listIndexes, new String[][]{{RUTH, "POEMS", "POEMTEXT"}}, false);
        this.expectExecutionError(aliceConnection, NO_DDL_PRIV, UPDATE_POEMS_INDEX);
        this.expectExecutionError(aliceConnection, AUTH_NO_ACCESS_NOT_OWNER, DROP_POEMS_INDEX);
        this.goodStatement(ruthConnection, UPDATE_POEMS_INDEX);
        this.goodStatement(ruthConnection, DROP_PRIMARY_KEY);
        this.goodStatement(ruthConnection, UPDATE_POEMS_INDEX);
        this.goodStatement(ruthConnection, "alter table poems drop column versionStamp");
        this.expectExecutionError(ruthConnection, "42X04", UPDATE_POEMS_INDEX);
        this.expectExecutionError(ruthConnection, "42X04", viewPoemsIndex);
        this.goodStatement(ruthConnection, DROP_POEMS_INDEX);
        this.assertResults(ruthConnection, listIndexes, new String[0][], false);
        this.expectExecutionError(ruthConnection, "42Y55", DROP_POEMS_INDEX);
        this.dropSchema(ruthConnection);
        this.createSchema(ruthConnection, 4);
        this.goodStatement(ruthConnection, DROP_PRIMARY_KEY);
        this.expectExecutionError(ruthConnection, NO_PRIMARY_KEY, INDEX_POEMS);
        this.expectExecutionError(ruthConnection, "42504", UNLOAD_TOOL);
        this.goodStatement(dboConnection, UNLOAD_TOOL);
        this.dropSchema(ruthConnection);
    }

    public void test_002_userGrant() throws Exception {
        Permission[] permissions;
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        Connection aliceConnection = this.openUserConnection(ALICE);
        this.createSchema(ruthConnection, 4);
        this.goodStatement(dboConnection, LOAD_TOOL);
        this.goodStatement(ruthConnection, INDEX_POEMS);
        for (Permission permission : permissions = new Permission[]{new Permission("execute on function poems__poemText", "42504"), new Permission("select ( poemID ) on poems", "42502"), new Permission("select ( versionStamp ) on poems", "42502"), new Permission("select ( poemText ) on poems", "42502")}) {
            this.grantPermission(ruthConnection, permission.text, ALICE);
        }
        String viewPoemsIndex = "select * from table ( ruth.poems__poemText( 'star', 1000, null ) ) luceneResults order by poemid";
        String[][] viewPoemsIndexResults = new String[][]{{"3", "3", "2", "0.22933942"}, {"4", "4", "3", "0.22933942"}, {"5", "5", "4", "0.26756266"}};
        this.assertResults(aliceConnection, viewPoemsIndex, viewPoemsIndexResults, false);
        for (Permission permission : permissions) {
            this.vetPermission_002(permission, ruthConnection, aliceConnection, viewPoemsIndex, viewPoemsIndexResults);
        }
        this.expectExecutionError(aliceConnection, AUTH_NO_ACCESS_NOT_OWNER, DROP_POEMS_INDEX);
        this.goodStatement(dboConnection, UNLOAD_TOOL);
        this.dropSchema(ruthConnection);
    }

    private void vetPermission_002(Permission permission, Connection ruthConnection, Connection aliceConnection, String statement, String[][] expectedResults) throws Exception {
        this.revokePermission(ruthConnection, permission.text, ALICE);
        this.expectExecutionError(aliceConnection, permission.sqlStateWhenMissing, statement);
        this.grantPermission(ruthConnection, permission.text, ALICE);
        this.assertResults(aliceConnection, statement, expectedResults, false);
    }

    private void grantPermission(Connection conn, String permission, String grantee) throws Exception {
        String command = "grant " + permission + " to " + grantee;
        this.goodStatement(conn, command);
    }

    private void revokePermission(Connection conn, String permission, String grantee) throws Exception {
        String command = "revoke " + permission + " from " + grantee;
        if (permission.startsWith("execute") || permission.startsWith("usage")) {
            command = command + " restrict";
        }
        this.goodStatement(conn, command);
    }

    public void test_003_loading() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        this.createSchema(ruthConnection, 4);
        this.goodStatement(dboConnection, "grant execute on procedure syscs_util.syscs_register_tool to public");
        this.expectExecutionError(ruthConnection, DBO_ONLY, LOAD_TOOL);
        this.goodStatement(dboConnection, LOAD_TOOL);
        this.expectExecutionError(dboConnection, DOUBLE_LOAD_ILLEGAL, LOAD_TOOL);
        this.expectExecutionError(ruthConnection, NOT_INDEXABLE, "call LuceneSupport.createIndex( 'ruth', 'foo', 'poemText', null )");
        this.expectExecutionError(ruthConnection, NOT_INDEXABLE, "call LuceneSupport.createIndex( 'ruth', 'poems', 'fooText', null )");
        this.expectExecutionError(ruthConnection, NOT_INDEXABLE, "call LuceneSupport.createIndex( 'ruth', 'poems', 'versionStamp', null )");
        this.expectExecutionError(ruthConnection, "42Y55", "call LuceneSupport.dropIndex( 'ruth', 'foo', 'poemText' )");
        this.expectExecutionError(ruthConnection, "42Y55", "call LuceneSupport.dropIndex( 'ruth', 'poems', 'versionStamp' )");
        this.expectExecutionError(ruthConnection, DBO_ONLY, UNLOAD_TOOL);
        this.goodStatement(dboConnection, "revoke execute on procedure syscs_util.syscs_register_tool from public restrict");
        this.goodStatement(dboConnection, UNLOAD_TOOL);
        this.expectExecutionError(dboConnection, DOUBLE_UNLOAD_ILLEGAL, UNLOAD_TOOL);
        this.goodStatement(dboConnection, LOAD_TOOL);
        this.goodStatement(dboConnection, UNLOAD_TOOL);
        this.dropSchema(ruthConnection);
    }

    public void test_004_datatypes() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        this.goodStatement(dboConnection, LOAD_TOOL);
        this.vet_004(ruthConnection, -5);
        this.vet_004(ruthConnection, 16);
        this.vet_004(ruthConnection, 1);
        this.vet_004(ruthConnection, -2);
        this.vet_004(ruthConnection, 91);
        this.vet_004(ruthConnection, 3);
        this.vet_004(ruthConnection, 8);
        this.vet_004(ruthConnection, 6);
        this.vet_004(ruthConnection, 4);
        this.vet_004(ruthConnection, 2);
        this.vet_004(ruthConnection, 7);
        this.vet_004(ruthConnection, 5);
        this.vet_004(ruthConnection, 92);
        this.vet_004(ruthConnection, 93);
        this.vet_004(ruthConnection, 12);
        this.vet_004(ruthConnection, -3);
        this.goodStatement(dboConnection, UNLOAD_TOOL);
    }

    private void vet_004(Connection ruthConnection, int jdbcType) throws Exception {
        this.createSchema(ruthConnection, jdbcType);
        this.goodStatement(ruthConnection, INDEX_POEMS);
        this.assertResults(ruthConnection, "select p.originalAuthor, i.score\nfrom ruth.poems p, table ( ruth.poems__poemText( 'star', 1000, null ) ) i\nwhere p.poemID = i.poemID and p.versionStamp = i.versionStamp\norder by i.score desc\n", new String[][]{{"Walt Whitman", "0.26756266"}, {"Lord Byron", "0.22933942"}, {"John Milton", "0.22933942"}}, false);
        this.goodStatement(ruthConnection, DROP_POEMS_INDEX);
        this.dropSchema(ruthConnection);
    }

    public void test_005_deleteDirectory() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        this.createSchema(ruthConnection, 4);
        this.goodStatement(dboConnection, LOAD_TOOL);
        this.goodStatement(ruthConnection, INDEX_POEMS);
        TestConfiguration config = this.getTestConfiguration();
        String dbName = config.getDefaultDatabaseName();
        String physicalDBName = config.getPhysicalDatabaseName(dbName);
        String dbPath = config.getDatabasePath(physicalDBName);
        File dbDirectory = new File(dbPath);
        File luceneDirectory = new File(dbDirectory, "LUCENE");
        File ruthDirectory = new File(luceneDirectory, RUTH);
        File poemsDirectory = new File(ruthDirectory, "POEMS");
        File poemTextIndexDirectory = new File(poemsDirectory, "POEMTEXT");
        LuceneSupportPermsTest.assertTrue((boolean)this.deleteFile(poemTextIndexDirectory));
        this.goodStatement(ruthConnection, DROP_POEMS_INDEX);
        this.expectCompilationError(ruthConnection, NONEXISTENT_TABLE_FUNCTION, "select * from table( ruth.textTable__textCol( 'one two three four five six seven eight nine ten', 100, null ) ) t");
        this.goodStatement(dboConnection, UNLOAD_TOOL);
        this.dropSchema(ruthConnection);
    }

    public void test_006_changeAnalyzer() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        this.createSchema(ruthConnection, 4);
        this.goodStatement(dboConnection, LOAD_TOOL);
        this.goodStatement(ruthConnection, INDEX_POEMS);
        this.assertResults(ruthConnection, "values ( substr( getDatabaseLocale(), 1, 2 ) )", new String[][]{{LANGUAGE}}, false);
        String query = "select p.originalAuthor, i.score\nfrom ruth.poems p, table ( ruth.poems__poemText( 'star', 1000, null ) ) i\nwhere p.poemID = i.poemID and p.versionStamp = i.versionStamp\norder by i.score desc\n";
        this.assertResults(ruthConnection, query, new String[][]{{"Walt Whitman", "0.26756266"}, {"Lord Byron", "0.22933942"}, {"John Milton", "0.22933942"}}, false);
        this.goodStatement(ruthConnection, "call LuceneSupport.updateIndex( 'ruth', 'poems', 'poemText', 'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )");
        this.assertResults(ruthConnection, query, new String[][]{{"Walt Whitman", "0.3304931"}, {"John Milton", "0.2832798"}}, false);
        this.goodStatement(ruthConnection, "call LuceneSupport.createIndex( 'ruth', 'poems', 'originalAuthor', null )");
        this.assertResults(ruthConnection, "select schemaName, tableName, columnName, luceneVersion, analyzer, indexDescriptorMaker\nfrom table( LuceneSupport.listIndexes() ) l\norder by schemaName, tableName, columnName\n", new String[][]{{RUTH, "POEMS", "ORIGINALAUTHOR", LUCENE_VERSION, "org.apache.lucene.analysis.en.EnglishAnalyzer", DEFAULT_INDEX_DESCRIPTOR}, {RUTH, "POEMS", "POEMTEXT", LUCENE_VERSION, "org.apache.lucene.analysis.standard.StandardAnalyzer", "org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer"}}, false);
        this.goodStatement(ruthConnection, DROP_POEMS_INDEX);
        this.goodStatement(ruthConnection, "call LuceneSupport.dropIndex( 'ruth', 'poems', 'originalAuthor' )");
        this.goodStatement(dboConnection, UNLOAD_TOOL);
        this.dropSchema(ruthConnection);
    }

    public void test_007_indexViews() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        this.createSchema(ruthConnection, 4);
        this.createPoemView(ruthConnection);
        this.goodStatement(dboConnection, LOAD_TOOL);
        this.goodStatement(ruthConnection, INDEX_POEMS);
        this.expectExecutionError(ruthConnection, NO_PRIMARY_KEY, "call LuceneSupport.createIndex( 'ruth', 'poemView', 'poemText', null )");
        this.goodStatement(ruthConnection, "call LuceneSupport.createIndex( 'ruth', 'poemView', 'poemText', null, 'poemID', 'versionStamp' )");
        this.expectExecutionError(ruthConnection, FUNCTION_EXISTS, "call LuceneSupport.createIndex( 'ruth', 'poemView', 'poemText', null, 'poemID' )");
        String selectFromViewIndex = "select p.originalAuthor, i.score\nfrom ruth.poems p, table ( ruth.poemView__poemText( 'star', 1000, null ) ) i\nwhere p.poemID = i.poemID and p.versionStamp = i.versionStamp\norder by i.score desc\n";
        this.assertResults(ruthConnection, selectFromViewIndex, new String[][]{{"Walt Whitman", "0.26756266"}, {"Lord Byron", "0.22933942"}, {"John Milton", "0.22933942"}}, false);
        String selectIndexes = "select schemaName, tableName, columnName, indexDescriptorMaker\nfrom table( LuceneSupport.listIndexes() ) l\norder by schemaName, tableName, columnName\n";
        this.assertResults(ruthConnection, selectIndexes, new String[][]{{RUTH, "POEMS", "POEMTEXT", DEFAULT_INDEX_DESCRIPTOR}, {RUTH, "POEMVIEW", "POEMTEXT", DEFAULT_INDEX_DESCRIPTOR}}, false);
        this.goodStatement(ruthConnection, "call LuceneSupport.updateIndex( 'ruth', 'poemView', 'poemText', 'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )");
        this.assertResults(ruthConnection, selectFromViewIndex, new String[][]{{"Walt Whitman", "0.3304931"}, {"John Milton", "0.2832798"}}, false);
        this.assertResults(ruthConnection, selectIndexes, new String[][]{{RUTH, "POEMS", "POEMTEXT", DEFAULT_INDEX_DESCRIPTOR}, {RUTH, "POEMVIEW", "POEMTEXT", "org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer"}}, false);
        this.goodStatement(ruthConnection, "call LuceneSupport.dropIndex( 'ruth', 'poemView', 'poemText' )");
        this.assertResults(ruthConnection, selectIndexes, new String[][]{{RUTH, "POEMS", "POEMTEXT", DEFAULT_INDEX_DESCRIPTOR}}, false);
        this.goodStatement(ruthConnection, DROP_POEMS_INDEX);
        this.goodStatement(ruthConnection, "call LuceneSupport.createIndex( 'ruth', 'poems', 'poemText', null, 'poemID' )");
        this.assertResults(ruthConnection, "select *\nfrom table ( ruth.poems__poemText( 'star', 1000, null ) ) i\norder by i.score desc\n", new String[][]{{"5", "4", "0.26756266"}, {"4", "3", "0.22933942"}, {"3", "2", "0.22933942"}}, false);
        this.goodStatement(ruthConnection, DROP_POEMS_INDEX);
        this.goodStatement(dboConnection, UNLOAD_TOOL);
        this.goodStatement(ruthConnection, "drop view poemView");
        this.dropSchema(ruthConnection);
    }

    public void test_008_columnNames() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        this.goodStatement(dboConnection, LOAD_TOOL);
        this.goodStatement(ruthConnection, "create table badTable1( keyCol int primary key, score clob )");
        this.goodStatement(ruthConnection, "create table badTable2( keyCol int primary key, documentID clob )");
        this.goodStatement(ruthConnection, "create table badTable3( score int primary key, textCol clob )");
        this.goodStatement(ruthConnection, "create table badTable4( documentID int primary key, textCol clob )");
        this.expectExecutionError(ruthConnection, BAD_COLUMN_NAME, "call LuceneSupport.createIndex( 'ruth', 'badTable1', 'score', null )");
        this.expectExecutionError(ruthConnection, BAD_COLUMN_NAME, "call LuceneSupport.createIndex( 'ruth', 'badTable2', 'documentID', null )");
        this.expectExecutionError(ruthConnection, BAD_COLUMN_NAME, "call LuceneSupport.createIndex( 'ruth', 'badTable3', 'textCol', null )");
        this.expectExecutionError(ruthConnection, BAD_COLUMN_NAME, "call LuceneSupport.createIndex( 'ruth', 'badTable4', 'textCol', null )");
        this.goodStatement(dboConnection, UNLOAD_TOOL);
        this.goodStatement(ruthConnection, "drop table badTable1");
        this.goodStatement(ruthConnection, "drop table badTable2");
        this.goodStatement(ruthConnection, "drop table badTable3");
        this.goodStatement(ruthConnection, "drop table badTable4");
    }

    public void test_009_searchArgs() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        LuceneSupportPermsTest.loadTestTable(ruthConnection);
        this.goodStatement(dboConnection, LOAD_TOOL);
        this.goodStatement(ruthConnection, "call LuceneSupport.createIndex( 'ruth', 'textTable', 'textCol', null )");
        this.assertResults(ruthConnection, "select * from table( ruth.textTable__textCol( 'one two three four five six seven eight nine ten', 100, null ) ) t", new String[][]{{"10", "9", "2.2791052"}, {"9", "8", "1.6305782"}, {"8", "7", "1.1616905"}, {"7", "6", "0.97469425"}, {"6", "5", "0.6597747"}, {"5", "4", "0.49575216"}, {"4", "3", "0.33803377"}, {"3", "2", "0.17799875"}, {"2", "1", "0.09289266"}, {"1", "0", "0.035006654"}}, false);
        this.assertResults(ruthConnection, "select * from table( ruth.textTable__textCol( 'one two three four five six seven eight nine ten', 3, null ) ) t", new String[][]{{"10", "9", "2.2791052"}, {"9", "8", "1.6305782"}, {"8", "7", "1.1616905"}}, false);
        this.assertResults(ruthConnection, "select * from table( ruth.textTable__textCol( 'one two three four five six seven eight nine ten', 4, 1.0 ) ) t", new String[][]{{"7", "6", "0.97469425"}, {"6", "5", "0.6597747"}, {"5", "4", "0.49575216"}, {"4", "3", "0.33803377"}}, false);
        this.assertResults(ruthConnection, "select * from table( ruth.textTable__textCol( 'one two three four five six seven eight nine ten', 100, 0.2 ) ) t", new String[][]{{"3", "2", "0.17799875"}, {"2", "1", "0.09289266"}, {"1", "0", "0.035006654"}}, false);
        this.goodStatement(ruthConnection, "call LuceneSupport.dropIndex( 'ruth', 'textTable', 'textCol' )");
        this.goodStatement(ruthConnection, "call LuceneSupport.createIndex( 'ruth', 'textTable', 'textCol', 'org.apache.derbyTesting.functionTests.tests.lang.LuceneSupportPermsTest.constantStringIndexDescriptor' )");
        this.assertResults(ruthConnection, "select * from table( ruth.textTable__textCol( 'one two three four five six seven eight nine ten', 100, null ) ) t", new String[][]{{"1", "0", "1.597837"}, {"2", "1", "0.9986481"}, {"3", "2", "0.7989185"}, {"4", "3", "0.7989185"}, {"5", "4", "0.69905365"}, {"6", "5", "0.59918886"}, {"7", "6", "0.59918886"}, {"8", "7", "0.49932405"}, {"9", "8", "0.49932405"}, {"10", "9", "0.49932405"}}, false);
        this.goodStatement(dboConnection, UNLOAD_TOOL);
        LuceneSupportPermsTest.unloadTestTable(ruthConnection);
    }

    static void loadTestTable(Connection conn) throws Exception {
        conn.prepareStatement("create table textTable( keyCol int primary key, textCol clob )").execute();
        conn.prepareStatement("insert into textTable values\n( 1, 'one' ),\n( 2, 'one two' ),\n( 3, 'one two three' ),\n( 4, 'one two three four' ),\n( 5, 'one two three four five' ),\n( 6, 'one two three four five six' ),\n( 7, 'one two three four five six seven' ),\n( 8, 'one two three four five six seven eight' ),\n( 9, 'one two three four five six seven eight nine' ),\n( 10, 'one two three four five six seven eight nine ten' ),\n( 101, 'bricks' ),\n( 102, 'bricks and mortar' ),\n( 103, 'bricks and mortar, tea' ),\n( 104, 'bricks and mortar, tea, tears' ),\n( 105, 'bricks and mortar, tea, tears, turtle' ),\n( 106, 'bricks and mortar, tea, tears, turtle, soup' ),\n( 107, 'bricks and mortar, tea, tears, turtle, soup, when in the course' ),\n( 108, 'bricks and mortar, tea, tears, turtle, soup, when in the course of human events' ),\n( 109, 'bricks and mortar, tea, tears, turtle, soup, when in the course of human events you want' ),\n( 110, 'bricks and mortar, tea, tears, turtle, soup, when in the course of human events you want better cell coverage' )\n").execute();
    }

    static void unloadTestTable(Connection conn) throws Exception {
        conn.prepareStatement("drop table textTable").execute();
    }

    public void test_010_encryption() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        String password = this.getTestConfiguration().getPassword(TEST_DBO);
        String encryptDatabaseURL = "jdbc:derby:lucenesupportpermsdb;user=TEST_DBO;password=" + password + ";dataEncryption=true;bootPassword=tryToGuessThis";
        String decryptDatabaseURL = "jdbc:derby:lucenesupportpermsdb;user=TEST_DBO;password=" + password + ";decryptDatabase=true;bootPassword=tryToGuessThis";
        this.goodStatement(dboConnection, LOAD_TOOL);
        this.getTestConfiguration().shutdownDatabase();
        try {
            DriverManager.getConnection(encryptDatabaseURL);
            LuceneSupportPermsTest.fail((String)"Should not have been able to get a connection!");
        }
        catch (SQLException se) {
            LuceneSupportPermsTest.assertSQLState(INCOMPATIBLE_ENCRYPTION, se);
        }
        dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, UNLOAD_TOOL);
        this.getTestConfiguration().shutdownDatabase();
        dboConnection = DriverManager.getConnection(encryptDatabaseURL);
        this.expectExecutionError(dboConnection, INCOMPATIBLE_ENCRYPTION, LOAD_TOOL);
        this.getTestConfiguration().shutdownDatabase();
        dboConnection = DriverManager.getConnection(decryptDatabaseURL);
    }

    public void test_011_fieldNames() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        LuceneSupportPermsTest.loadTestTable(ruthConnection);
        this.goodStatement(dboConnection, LOAD_TOOL);
        String indexTestTable = "call LuceneSupport.createIndex\n(\n    'ruth', 'textTable', 'textCol',\n    'org.apache.derbyTesting.functionTests.tests.lang.LuceneSupportPermsTest.makeFieldNameIndexDescriptor'\n)\n";
        this.goodStatement(ruthConnection, "create procedure setFieldNames( fieldName varchar( 32672 )... )\nlanguage java parameter style derby no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.LuceneSupportPermsTest.setFieldNames'\n");
        this.goodStatement(ruthConnection, "call setFieldNames( 'KEYCOL' )");
        this.expectExecutionError(ruthConnection, BAD_FIELD_NAME, indexTestTable);
        this.goodStatement(ruthConnection, "call setFieldNames( 'FOO', 'FOO' )");
        this.expectExecutionError(ruthConnection, DUPLICATE_FIELD_NAME, indexTestTable);
        this.goodStatement(ruthConnection, "call setFieldNames( 'FOO', null )");
        this.expectExecutionError(ruthConnection, DUPLICATE_FIELD_NAME, indexTestTable);
        this.goodStatement(ruthConnection, "call setFieldNames( null, 'FOO' )");
        this.expectExecutionError(ruthConnection, DUPLICATE_FIELD_NAME, indexTestTable);
        this.goodStatement(ruthConnection, "drop procedure setFieldNames");
        this.goodStatement(dboConnection, UNLOAD_TOOL);
        LuceneSupportPermsTest.unloadTestTable(ruthConnection);
    }

    public void test_6602() throws Exception {
        CD[] columnDescriptors = new CD[]{new CD("bigintCol", "bigint"), new CD("blobCol", "blob"), new CD("booleanCol", "boolean"), new CD("charCol", "char( 10 )"), new CD("clobCol", "clob"), new CD("dataCol", "date"), new CD("decimalCol", "decimal"), new CD("doubleCol", "double"), new CD("floatCol", "float"), new CD("intCol", "int"), new CD("longvarcharCol", "long varchar"), new CD("longvarcharforbitdataCol", "long varchar for bit data"), new CD("numericCol", "numeric"), new CD("realCol", "real"), new CD("smallintCol", "smallint"), new CD("timeCol", "time"), new CD("varcharCol", "varchar( 10 )"), new CD("varcharforbitdataCol", "varchar( 10 ) for bit data")};
        StringBuilder buffer = new StringBuilder();
        buffer.append("create table t_6602\n(\ttextcol clob");
        for (CD cd : columnDescriptors) {
            buffer.append(",\n\t" + cd.name + " " + cd.type);
        }
        buffer.append("\n)");
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, LOAD_TOOL);
        this.goodStatement(dboConnection, buffer.toString());
        this.goodStatement(dboConnection, "insert into t_6602( textcol ) values ( 'abc'), ( 'def')");
        for (CD cd : columnDescriptors) {
            this.vet6602(dboConnection, cd);
        }
        this.goodStatement(dboConnection, "drop table t_6602");
        this.goodStatement(dboConnection, UNLOAD_TOOL);
    }

    private void vet6602(Connection conn, CD cd) throws Exception {
        PreparedStatement ps = this.chattyPrepare(conn, "call lucenesupport.createindex\n( 'TEST_DBO', 't_6602', 'textcol', 'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer', ? )");
        ps.setString(1, cd.name);
        ps.execute();
        this.assertResults(conn, "select * from table( t_6602__textcol( 'abc or def', 3, null ) ) tc order by documentid", new String[][]{{null, "0", "0.35355338"}, {null, "1", "0.35355338"}}, false);
        this.goodStatement(conn, "call lucenesupport.dropIndex( 'TEST_DBO', 't_6602', 'textcol' )");
    }

    public void test_6596_null_args() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, LOAD_TOOL);
        this.goodStatement(dboConnection, "create table t_6596( x int primary key, c clob )");
        this.goodStatement(dboConnection, "insert into t_6596 values ( 1, 'abc' ), ( 2, 'def' )");
        this.expectExecutionError(dboConnection, ILLEGAL_NULL_ARG, "call lucenesupport.createindex( null, 't_6596', 'c',  'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )");
        this.expectExecutionError(dboConnection, ILLEGAL_NULL_ARG, "call lucenesupport.createindex( 'TEST_DBO', null, 'c',  'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )");
        this.expectExecutionError(dboConnection, ILLEGAL_NULL_ARG, "call lucenesupport.createindex( 'TEST_DBO', 't_6596', null,  'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )");
        this.expectExecutionError(dboConnection, ILLEGAL_NULL_ARG, "call lucenesupport.createindex( 'TEST_DBO', 't_6596', 'c',  'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer', null )");
        this.expectExecutionError(dboConnection, ILLEGAL_NULL_ARG, "call lucenesupport.createindex( 'TEST_DBO', 't_6596', 'c',  'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer', 'x', null )");
        this.goodStatement(dboConnection, "call lucenesupport.createindex( 'TEST_DBO', 't_6596', 'c',  'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )");
        this.assertResults(dboConnection, "select * from table( t_6596__c( 'abc or def', 3, null ) ) tc order by documentid", new String[][]{{"1", "0", "0.35355338"}, {"2", "1", "0.35355338"}}, false);
        this.goodStatement(dboConnection, "call lucenesupport.updateindex( 'TEST_DBO', 't_6596', 'c',  'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )");
        this.expectExecutionError(dboConnection, ILLEGAL_NULL_ARG, "call lucenesupport.updateindex( null, 't_6596', 'c',  'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )");
        this.expectExecutionError(dboConnection, ILLEGAL_NULL_ARG, "call lucenesupport.updateindex( 'TEST_DBO', null, 'c',  'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )");
        this.expectExecutionError(dboConnection, ILLEGAL_NULL_ARG, "call lucenesupport.updateindex( 'TEST_DBO', 't_6596', null,  'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )");
        this.expectExecutionError(dboConnection, ILLEGAL_NULL_ARG, "select * from table( t_6596__c( null, 3, null ) ) tc order by documentid");
        this.expectExecutionError(dboConnection, NULL_PRIMITIVE_ARG, "select * from table( t_6596__c( 'abc or def', null, null ) ) tc order by documentid");
        this.expectExecutionError(dboConnection, ILLEGAL_NULL_ARG, "call lucenesupport.dropindex( null, 't_6596', 'c' )");
        this.expectExecutionError(dboConnection, ILLEGAL_NULL_ARG, "call lucenesupport.dropindex( 'TEST_DBO', null, 'c' )");
        this.expectExecutionError(dboConnection, ILLEGAL_NULL_ARG, "call lucenesupport.dropindex( 'TEST_DBO', 't_6596', null )");
        this.goodStatement(dboConnection, "call lucenesupport.dropindex( 'TEST_DBO', 't_6596', 'c' )");
        this.goodStatement(dboConnection, "drop table t_6596");
        this.goodStatement(dboConnection, UNLOAD_TOOL);
    }

    public void test_6730() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        this.createSchema(ruthConnection, 4);
        this.goodStatement(ruthConnection, "create view v_6730_1 ( poemID, poemText ) as select poemID, poemText from ruth.poems");
        this.goodStatement(ruthConnection, "create view v_6730_2 ( poemID, \"poemText\" ) as select poemID, poemText from ruth.poems");
        this.goodStatement(ruthConnection, "create view v_6730_3 ( \"poemID\", poemText ) as select poemID, poemText from ruth.poems");
        this.goodStatement(ruthConnection, "create view v_6730_4 ( \"poemID\", \"poemText\" ) as select poemID, poemText from ruth.poems");
        this.goodStatement(ruthConnection, "create view v_6730_5 ( poemID, \"c l o b\" ) as select poemID, poemText from ruth.poems");
        this.goodStatement(ruthConnection, "create view v_6730_6 ( \"k e y\", poemText ) as select poemID, poemText from ruth.poems");
        this.goodStatement(dboConnection, LOAD_TOOL);
        this.goodStatement(ruthConnection, "call luceneSupport.createIndex\n(\n  'ruth',\n  'v_6730_1',\n  'poemText',\n  null,\n  'poemID'\n)\n");
        this.goodStatement(ruthConnection, "call luceneSupport.createIndex\n(\n  'ruth',\n  'v_6730_2',\n  '\"poemText\"',\n  null,\n  'poemID'\n)\n");
        this.goodStatement(ruthConnection, "call luceneSupport.createIndex\n(\n  'ruth',\n  'v_6730_3',\n  'poemText',\n  null,\n  '\"poemID\"'\n)\n");
        this.goodStatement(ruthConnection, "call luceneSupport.createIndex\n(\n  'ruth',\n  'v_6730_4',\n  '\"poemText\"',\n  null,\n  '\"poemID\"'\n)\n");
        this.goodStatement(ruthConnection, "call luceneSupport.createIndex\n(\n  'ruth',\n  'v_6730_5',\n  '\"c l o b\"',\n  null,\n  'poemID'\n)\n");
        this.goodStatement(ruthConnection, "call luceneSupport.createIndex\n(\n  'ruth',\n  'v_6730_6',\n  'poemText',\n  null,\n  '\"k e y\"'\n)\n");
        this.vet6730(ruthConnection);
        this.goodStatement(ruthConnection, "call luceneSupport.updateIndex\n(\n  'ruth',\n  'v_6730_1',\n  'poemText',\n  null\n)\n");
        this.goodStatement(ruthConnection, "call luceneSupport.updateIndex\n(\n  'ruth',\n  'v_6730_2',\n  '\"poemText\"',\n  null\n)\n");
        this.goodStatement(ruthConnection, "call luceneSupport.updateIndex\n(\n  'ruth',\n  'v_6730_3',\n  'poemText',\n  null\n)\n");
        this.goodStatement(ruthConnection, "call luceneSupport.updateIndex\n(\n  'ruth',\n  'v_6730_4',\n  '\"poemText\"',\n  null\n)\n");
        this.goodStatement(ruthConnection, "call luceneSupport.updateIndex\n(\n  'ruth',\n  'v_6730_5',\n  '\"c l o b\"',\n  null\n)\n");
        this.goodStatement(ruthConnection, "call luceneSupport.updateIndex\n(\n  'ruth',\n  'v_6730_6',\n  'poemText',\n  null\n)\n");
        this.vet6730(ruthConnection);
        this.goodStatement(ruthConnection, "call LuceneSupport.dropIndex( 'ruth', 'v_6730_1', 'poemText' )");
        this.goodStatement(ruthConnection, "call LuceneSupport.dropIndex( 'ruth', 'v_6730_2', '\"poemText\"' )");
        this.goodStatement(ruthConnection, "call LuceneSupport.dropIndex( 'ruth', 'v_6730_3', 'poemText' )");
        this.goodStatement(ruthConnection, "call LuceneSupport.dropIndex( 'ruth', 'v_6730_4', '\"poemText\"' )");
        this.goodStatement(ruthConnection, "call LuceneSupport.dropIndex( 'ruth', 'v_6730_5', '\"c l o b\"' )");
        this.goodStatement(ruthConnection, "call LuceneSupport.dropIndex( 'ruth', 'v_6730_6', 'poemText' )");
        this.goodStatement(dboConnection, UNLOAD_TOOL);
        this.goodStatement(ruthConnection, "drop view v_6730_6");
        this.goodStatement(ruthConnection, "drop view v_6730_5");
        this.goodStatement(ruthConnection, "drop view v_6730_4");
        this.goodStatement(ruthConnection, "drop view v_6730_3");
        this.goodStatement(ruthConnection, "drop view v_6730_2");
        this.goodStatement(ruthConnection, "drop view v_6730_1");
        this.dropSchema(ruthConnection);
    }

    private void vet6730(Connection conn) throws Exception {
        String[][] expectedResults = new String[][]{{"5", "0.26756266"}, {"4", "0.22933942"}, {"3", "0.22933942"}};
        this.assertResults(conn, "select i.poemID, i.score\nfrom table ( ruth.v_6730_1__poemText( 'star', 1000, null ) ) i\norder by i.score desc\n", expectedResults, false);
        this.assertResults(conn, "select i.poemID, i.score\nfrom table ( ruth.\"V_6730_2__poemText\"( 'star', 1000, null ) ) i\norder by i.score desc\n", expectedResults, false);
        this.assertResults(conn, "select i.\"poemID\", i.score\nfrom table ( ruth.v_6730_3__poemText( 'star', 1000, null ) ) i\norder by i.score desc\n", expectedResults, false);
        this.assertResults(conn, "select i.\"poemID\", i.score\nfrom table ( ruth.\"V_6730_4__poemText\"( 'star', 1000, null ) ) i\norder by i.score desc\n", expectedResults, false);
        this.assertResults(conn, "select i.poemID, i.score\nfrom table ( ruth.\"V_6730_5__c l o b\"( 'star', 1000, null ) ) i\norder by i.score desc\n", expectedResults, false);
        this.assertResults(conn, "select i.\"k e y\", i.score\nfrom table ( ruth.v_6730_6__poemText( 'star', 1000, null ) ) i\norder by i.score desc\n", expectedResults, false);
        String[][] expectedListResults = new String[][]{{RUTH, "V_6730_1", "POEMTEXT", "org.apache.lucene.analysis.en.EnglishAnalyzer"}, {RUTH, "V_6730_2", "poemText", "org.apache.lucene.analysis.en.EnglishAnalyzer"}, {RUTH, "V_6730_3", "POEMTEXT", "org.apache.lucene.analysis.en.EnglishAnalyzer"}, {RUTH, "V_6730_4", "poemText", "org.apache.lucene.analysis.en.EnglishAnalyzer"}, {RUTH, "V_6730_5", "c l o b", "org.apache.lucene.analysis.en.EnglishAnalyzer"}, {RUTH, "V_6730_6", "POEMTEXT", "org.apache.lucene.analysis.en.EnglishAnalyzer"}};
        this.assertResults(conn, "select schemaName, tableName, columnName, analyzer\nfrom table( lucenesupport.listIndexes() ) t\norder by schemaName, tableName, columnName\n", expectedListResults, false);
    }

    private void createSchema(Connection ruthConnection, int jdbcType) throws Exception {
        this.createPoemsTable(ruthConnection, jdbcType);
        this.createLocaleFunction(ruthConnection);
    }

    private void createPoemsTable(Connection conn, int jdbcType) throws Exception {
        this.goodStatement(conn, "create table poems\n(\n    poemID " + this.getType(jdbcType) + ",\n    versionStamp int not null,\n    originalAuthor       varchar( 50 ),\n    lastEditor           varchar( 50 ),\n    poemText            clob,\n    constraint poemsKey primary key( poemID, versionStamp )\n)\n");
        PreparedStatement ps = conn.prepareStatement("insert into poems values ( ?, ?, ?, ?, ? )");
        int poemID = 1;
        int versionStamp = 1;
        this.setNextPoemID(ps, jdbcType, poemID++);
        ps.setInt(2, versionStamp++);
        ps.setString(3, "Geoffrey Chaucer");
        ps.setString(4, "Geoffrey Chaucer");
        ps.setString(5, "Whan that Aprill, with his shoures soote The droghte of March hath perced to the roote And bathed every veyne in swich licour, Of which vertu engendred is the flour;");
        ps.executeUpdate();
        this.setNextPoemID(ps, jdbcType, poemID++);
        ps.setInt(2, versionStamp++);
        ps.setString(3, "Andrew Marvell");
        ps.setString(4, "Andrew Marvell");
        ps.setString(5, "Had we but world enough, and time, This coyness, lady, were no crime.");
        ps.executeUpdate();
        this.setNextPoemID(ps, jdbcType, poemID++);
        ps.setInt(2, versionStamp++);
        ps.setString(3, "John Milton");
        ps.setString(4, "John Milton");
        ps.setString(5, "From morn to noon he fell, from noon to dewy eve, a summers day, and with the setting sun dropped from the ze4ith like a falling star on Lemnos, the Aegean isle");
        ps.executeUpdate();
        this.setNextPoemID(ps, jdbcType, poemID++);
        ps.setInt(2, versionStamp++);
        ps.setString(3, "Lord Byron");
        ps.setString(4, "Lord Byron");
        ps.setString(5, "The Assyrian came down like the wolf on the fold, And his cohorts were gleaming in purple and gold; And the sheen of their spears was like stars on the sea, When the blue wave rolls nightly on deep Galilee.");
        ps.executeUpdate();
        this.setNextPoemID(ps, jdbcType, poemID++);
        ps.setInt(2, versionStamp++);
        ps.setString(3, "Walt Whitman");
        ps.setString(4, "Walt Whitman");
        ps.setString(5, "When lilacs last in the dooryard bloomd, And the great star early droopd in the western sky in the night, I mournd, and yet shall mourn with ever-returning spring.");
        ps.executeUpdate();
        ps.close();
    }

    private void createPoemView(Connection conn) throws Exception {
        this.goodStatement(conn, "create view poemView as select poemID, versionStamp, poemText from poems");
    }

    private void createLocaleFunction(Connection conn) throws Exception {
        this.goodStatement(conn, "create function getDatabaseLocale() returns varchar( 20 )\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.LuceneSupportPermsTest.getDatabaseLocale()'\n");
    }

    private String getType(int jdbcType) throws Exception {
        switch (jdbcType) {
            case -2: {
                return "char( 100 ) for bit data";
            }
            case 16: {
                return "boolean";
            }
            case 3: {
                return "decimal";
            }
            case 4: {
                return "int";
            }
            case -5: {
                return "bigint";
            }
            case 5: {
                return "smallint";
            }
            case 8: {
                return "double";
            }
            case 6: {
                return "real";
            }
            case 2: {
                return "numeric";
            }
            case 1: {
                return "char( 5 )";
            }
            case 7: {
                return "real";
            }
            case 12: {
                return "varchar( 5 )";
            }
            case -3: {
                return "varchar( 256 ) for bit data";
            }
            case 91: {
                return "date";
            }
            case 92: {
                return "time";
            }
            case 93: {
                return "timestamp";
            }
        }
        throw new Exception("Unsupported datatype: " + jdbcType);
    }

    private void setNextPoemID(PreparedStatement ps, int jdbcType, int intPoemID) throws Exception {
        switch (jdbcType) {
            case -2: {
                ps.setBytes(1, LuceneSupportPermsTest.makeBytes(intPoemID));
                break;
            }
            case 16: {
                ps.setBoolean(1, intPoemID % 2 == 0);
                break;
            }
            case 2: 
            case 3: {
                ps.setBigDecimal(1, new BigDecimal(intPoemID));
                break;
            }
            case 4: {
                ps.setInt(1, intPoemID);
                break;
            }
            case -5: {
                ps.setLong(1, (long)intPoemID + Integer.MAX_VALUE);
                break;
            }
            case 5: {
                ps.setShort(1, (short)intPoemID);
                break;
            }
            case 8: {
                ps.setDouble(1, intPoemID);
                break;
            }
            case 6: 
            case 7: {
                ps.setFloat(1, intPoemID);
                break;
            }
            case 1: 
            case 12: {
                ps.setString(1, this.makeStringKey(intPoemID));
                break;
            }
            case -3: {
                ps.setBytes(1, LuceneSupportPermsTest.makeAllBytes(intPoemID));
                break;
            }
            case 91: {
                ps.setDate(1, new Date(86400000L * (long)(500 + intPoemID)));
                break;
            }
            case 92: {
                ps.setTime(1, new Time(3600000L * (long)intPoemID));
                break;
            }
            case 93: {
                ps.setTimestamp(1, new Timestamp(86400000L * (long)(500 + intPoemID)));
                break;
            }
            default: {
                throw new Exception("Unsupported datatype: " + jdbcType);
            }
        }
    }

    private String makeStringKey(int key) {
        String digit = Integer.toString(key);
        return digit + digit + digit + digit + digit;
    }

    private void dropSchema(Connection ruthConnection) throws Exception {
        this.goodStatement(ruthConnection, "drop table poems");
        this.goodStatement(ruthConnection, "drop function getDatabaseLocale");
    }

    public static String getDatabaseLocale() throws SQLException {
        return ConnectionUtil.getCurrentLCC().getDatabase().getLocale().toString();
    }

    public static String toString(byte[] value) {
        if (value == null) {
            return null;
        }
        return Arrays.toString(value);
    }

    public static byte[] makeAllBytes(int initialValue) {
        int size = 256;
        byte[] result = new byte[size];
        int value = initialValue;
        if (value < -128) {
            value = -128;
        }
        if (value > 127) {
            value = 127;
        }
        for (int idx = 0; idx < size; ++idx) {
            result[idx] = (byte)value++;
            if (value <= 127) continue;
            value = -128;
        }
        return result;
    }

    public static byte[] makeBytes(int initialValue) {
        byte[] result = new byte[initialValue];
        for (int idx = 0; idx < initialValue; ++idx) {
            result[idx] = (byte)initialValue;
        }
        return result;
    }

    public static LuceneIndexDescriptor constantStringIndexDescriptor() {
        return new ConstantIndexDescriptor();
    }

    private boolean deleteFile(File file) throws IOException, PrivilegedActionException {
        boolean retval = true;
        if (this.isDirectory(file)) {
            for (File child : this.listFiles(file)) {
                retval = retval && this.deleteFile(child);
            }
        }
        return retval && this.clobberFile(file);
    }

    private boolean isDirectory(final File file) throws IOException, PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws IOException {
                if (file == null) {
                    return false;
                }
                return file.isDirectory();
            }
        });
    }

    private boolean clobberFile(final File file) throws IOException, PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws IOException {
                return file.delete();
            }
        });
    }

    private File[] listFiles(final File file) throws IOException, PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<File[]>(){

            @Override
            public File[] run() throws IOException {
                return file.listFiles();
            }
        });
    }

    public static void setFieldNames(String ... fieldNames) {
        _fieldNames = fieldNames;
    }

    public static LuceneIndexDescriptor makeFieldNameIndexDescriptor() {
        return new FieldNameIndexDescriptor();
    }

    public static class FieldNameIndexDescriptor
    extends LuceneUtils.DefaultIndexDescriptor {
        public String[] getFieldNames() {
            return _fieldNames;
        }
    }

    public static class ConstantIndexDescriptor
    extends LuceneUtils.DefaultIndexDescriptor {
        public QueryParser getQueryParser() throws SQLException {
            return new ConstantQueryParser(LuceneUtils.currentVersion(), this.getFieldNames(), this.getAnalyzer());
        }
    }

    public static class CD {
        public final String name;
        public final String type;

        public CD(String Name2, String Type2) {
            this.name = Name2;
            this.type = Type2;
        }

        public String toString() {
            return "[ " + this.name + ", " + this.type + " ]";
        }
    }

    public static class ConstantQueryParser
    extends MultiFieldQueryParser {
        public ConstantQueryParser(Version version, String[] fieldNames, Analyzer analyzer) {
            super(version, fieldNames, analyzer);
        }

        public Query parse(String query) throws ParseException {
            return super.parse("one");
        }
    }
}

