/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.drda;

import java.io.File;
import java.io.PrintWriter;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Properties;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.impl.drda.NetworkServerControlImpl;

public class NetworkServerControl {
    public static final int DEFAULT_PORTNUMBER = 1527;
    private static final String DERBYNET_JAR = "derbynet.jar";
    private static final String POLICY_FILENAME = "server.policy";
    private static final String POLICY_FILE_PROPERTY = "java.security.policy";
    private static final String DERBY_HOSTNAME_WILDCARD = "0.0.0.0";
    private static final String IPV6_HOSTNAME_WILDCARD = "::";
    private static final String SOCKET_PERMISSION_HOSTNAME_WILDCARD = "*";
    private NetworkServerControlImpl serverImpl;

    public NetworkServerControl(InetAddress address, int portNumber, String userName, String password) throws Exception {
        this.serverImpl = new NetworkServerControlImpl(address, portNumber, userName, password);
    }

    public NetworkServerControl(String userName, String password) throws Exception {
        this.serverImpl = new NetworkServerControlImpl(userName, password);
    }

    public NetworkServerControl(InetAddress address, int portNumber) throws Exception {
        this.serverImpl = new NetworkServerControlImpl(address, portNumber);
    }

    public NetworkServerControl() throws Exception {
        this.serverImpl = new NetworkServerControlImpl();
    }

    public static void main(String[] args) {
        NetworkServerControlImpl server = null;
        boolean printErrors = true;
        try {
            server = new NetworkServerControlImpl();
            int command = server.parseArgs(args);
            if (command == 0) {
                try {
                    AccessController.doPrivileged(() -> {
                        System.setProperty("derby.__serverStartedFromCmdLine", "true");
                        return null;
                    });
                }
                catch (Exception e) {
                    server.consoleExceptionPrintTrace(e);
                    System.exit(1);
                }
            }
            if (NetworkServerControl.needsSecurityManager(server, command)) {
                NetworkServerControl.verifySecurityState(server);
                NetworkServerControl.installSecurityManager(server);
            }
            printErrors = false;
            server.executeWork(command);
        }
        catch (Exception e) {
            if (e.getMessage() == null || !e.getMessage().equals("Unexpected exception") || printErrors) {
                if (server != null) {
                    server.consoleExceptionPrint(e);
                } else {
                    e.printStackTrace();
                }
            }
            System.exit(1);
        }
        System.exit(0);
    }

    public void start(PrintWriter consoleWriter) throws Exception {
        this.serverImpl.start(consoleWriter);
    }

    public void shutdown() throws Exception {
        this.serverImpl.shutdown();
    }

    public void ping() throws Exception {
        this.serverImpl.ping();
    }

    public void trace(boolean on) throws Exception {
        this.serverImpl.trace(on);
    }

    public void trace(int connNum, boolean on) throws Exception {
        this.serverImpl.trace(connNum, on);
    }

    public void logConnections(boolean on) throws Exception {
        this.serverImpl.logConnections(on);
    }

    public void setTraceDirectory(String traceDirectory) throws Exception {
        this.serverImpl.sendSetTraceDirectory(traceDirectory);
    }

    public String getSysinfo() throws Exception {
        return this.serverImpl.sysinfo();
    }

    public String getRuntimeInfo() throws Exception {
        return this.serverImpl.runtimeInfo();
    }

    public void setMaxThreads(int max) throws Exception {
        this.serverImpl.netSetMaxThreads(max);
    }

    public int getMaxThreads() throws Exception {
        String val = this.serverImpl.getCurrentProperties().getProperty("derby.drda.maxThreads");
        return Integer.parseInt(val);
    }

    public void setTimeSlice(int timeslice) throws Exception {
        this.serverImpl.netSetTimeSlice(timeslice);
    }

    public int getTimeSlice() throws Exception {
        String val = this.serverImpl.getCurrentProperties().getProperty("derby.drda.timeSlice");
        return Integer.parseInt(val);
    }

    public Properties getCurrentProperties() throws Exception {
        return this.serverImpl.getCurrentProperties();
    }

    protected void setClientLocale(String locale) {
        this.serverImpl.setClientLocale(locale);
    }

    private static boolean needsSecurityManager(NetworkServerControlImpl server, int command) throws Exception {
        return System.getSecurityManager() == null && command == 0 && !server.runningUnsecure();
    }

    private static void verifySecurityState(NetworkServerControlImpl server) throws Exception {
    }

    private static void installSecurityManager(NetworkServerControlImpl server) throws Exception {
        if (PropertyUtil.getSystemProperty("derby.system.home") == null) {
            System.setProperty("derby.system.home", PropertyUtil.getSystemProperty("user.dir"));
        }
        if (PropertyUtil.getSystemProperty("derby.drda.traceDirectory") == null) {
            System.setProperty("derby.drda.traceDirectory", PropertyUtil.getSystemProperty("derby.system.home"));
        }
        System.setProperty("derby.security.host", NetworkServerControl.getHostNameForSocketPermission(server));
        System.setProperty("derby.security.port", String.valueOf(server.getPort()));
        URL derbyInstallURL = NetworkServerControl.getCodeSourceURL(server);
        String derbyInstallStr = NetworkServerControl.getCodeSourcePrefix(server, derbyInstallURL);
        String derbyInstallPth = new File(derbyInstallURL.getFile()).getParentFile().getAbsolutePath();
        System.setProperty("derby.install.url", derbyInstallStr);
        System.setProperty("derby.install.path", derbyInstallPth);
        String policyFileURL = NetworkServerControl.getPolicyFileURL();
        System.setProperty(POLICY_FILE_PROPERTY, policyFileURL);
        SecurityManager securityManager = new SecurityManager();
        System.setSecurityManager(securityManager);
        if (securityManager.equals(System.getSecurityManager())) {
            String successMessage = server.localizeMessage("DRDA_SecurityInstalled.I", null);
            server.consoleMessage(successMessage, true);
        }
    }

    private static String getHostNameForSocketPermission(NetworkServerControlImpl server) throws Exception {
        String hostname = server.getHost();
        if (NetworkServerControl.hostnamesEqual(DERBY_HOSTNAME_WILDCARD, hostname) || IPV6_HOSTNAME_WILDCARD.equals(hostname)) {
            hostname = SOCKET_PERMISSION_HOSTNAME_WILDCARD;
        } else if (NetworkServerControl.isIPV6Address(hostname)) {
            hostname = '[' + hostname + "]:0-";
        }
        return hostname;
    }

    private static boolean hostnamesEqual(String left, String right) {
        try {
            InetAddress leftAddress = InetAddress.getByName(left);
            InetAddress rightAddress = InetAddress.getByName(right);
            return leftAddress.equals(rightAddress);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isIPV6Address(String hostname) {
        if (hostname == null) {
            return false;
        }
        int count = hostname.length();
        for (int i = 0; i < count; ++i) {
            char currentChar = hostname.charAt(i);
            if (currentChar == ':' || Character.digit(currentChar, 16) >= 0) continue;
            return false;
        }
        try {
            InetAddress address = InetAddress.getByName(hostname);
            return address instanceof Inet6Address;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static URL getCodeSourceURL(NetworkServerControlImpl server) throws Exception {
        ProtectionDomain pd = NetworkServerControl.class.getProtectionDomain();
        CodeSource cs = pd.getCodeSource();
        if (cs == null) {
            return null;
        }
        URL url = cs.getLocation();
        return url;
    }

    private static String getCodeSourcePrefix(NetworkServerControlImpl server, URL url) throws Exception {
        String extForm = url.toExternalForm().replaceFirst("^file://([^/].*)", "file:////$1");
        int idx = extForm.indexOf(DERBYNET_JAR);
        if (idx < 0) {
            String errorMessage = server.localizeMessage("DRDA_MissingNetworkJar.S", null);
            server.consoleError(errorMessage);
        }
        String directoryPrefix = extForm.substring(0, idx);
        return directoryPrefix;
    }

    private static String getPolicyFileURL() throws Exception {
        String resourceName = NetworkServerControl.class.getPackage().getName().replace('.', '/') + '/' + POLICY_FILENAME;
        URL resourceURL = NetworkServerControl.class.getClassLoader().getResource(resourceName);
        String stringForm = resourceURL.toExternalForm();
        return stringForm;
    }
}

