/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.TemporaryRowHolder;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.IndexRow;
import org.apache.derby.impl.sql.execute.ScanResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderResultSet;
import org.apache.derby.shared.common.sanity.SanityManager;

class DependentResultSet
extends ScanResultSet
implements CursorResultSet {
    ConglomerateController heapCC;
    RowLocation baseRowLocation;
    ExecRow indexRow;
    IndexRow indexQualifierRow;
    ScanController indexSC;
    StaticCompiledOpenConglomInfo indexScoci;
    DynamicCompiledOpenConglomInfo indexDcoci;
    int numFkColumns;
    boolean isOpen;
    TemporaryRowHolderResultSet source;
    TransactionController tc;
    String parentResultSetId;
    int[] fkColArray;
    RowLocation rowLocation;
    TemporaryRowHolder[] sourceRowHolders;
    TemporaryRowHolderResultSet[] sourceResultSets;
    int[] sourceOpened;
    int sArrayIndex;
    Vector<TemporaryRowHolder> sVector;
    protected ScanController scanController;
    protected boolean scanControllerOpened;
    protected boolean isKeyed;
    protected boolean firstScan = true;
    protected ExecIndexRow startPosition;
    protected ExecIndexRow stopPosition;
    protected long conglomId;
    protected DynamicCompiledOpenConglomInfo heapDcoci;
    protected StaticCompiledOpenConglomInfo heapScoci;
    protected int startSearchOperator;
    protected int stopSearchOperator;
    protected Qualifier[][] qualifiers;
    public String userSuppliedOptimizerOverrides;
    protected boolean runTimeStatisticsOn;
    public int rowsPerRead;
    public boolean forUpdate;
    private Properties scanProperties;
    public String startPositionString;
    public String stopPositionString;
    public boolean isConstraint;
    public boolean coarserLock;
    public boolean oneRowScan;
    protected long rowsThisScan;
    ExecRow searchRow = null;

    DependentResultSet(long conglomId, StaticCompiledOpenConglomInfo scoci, Activation activation, int resultRowTemplate, int resultSetNumber, GeneratedMethod startKeyGetter, int startSearchOperator, GeneratedMethod stopKeyGetter, int stopSearchOperator, boolean sameStartStopPosition, Qualifier[][] qualifiers, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, boolean forUpdate, int colRefItem, int lockMode, boolean tableLocked, int isolationLevel, int rowsPerRead, boolean oneRowScan, double optimizerEstimatedRowCount, double optimizerEstimatedCost, String parentResultSetId, long fkIndexConglomId, int fkColArrayItem, int rltItem) throws StandardException {
        super(activation, resultSetNumber, resultRowTemplate, lockMode, tableLocked, 4, colRefItem, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.conglomId = conglomId;
        this.heapScoci = scoci;
        this.heapDcoci = activation.getTransactionController().getDynamicCompiledConglomInfo(conglomId);
        SanityManager.ASSERT(startKeyGetter == null, "start key not null");
        SanityManager.ASSERT(stopKeyGetter == null, "stop key not null");
        this.startSearchOperator = startSearchOperator;
        this.stopSearchOperator = stopSearchOperator;
        this.qualifiers = qualifiers;
        this.tableName = tableName;
        this.userSuppliedOptimizerOverrides = userSuppliedOptimizerOverrides;
        this.indexName = "On Foreign Key";
        this.isConstraint = isConstraint;
        this.forUpdate = forUpdate;
        this.rowsPerRead = rowsPerRead;
        this.oneRowScan = oneRowScan;
        this.runTimeStatisticsOn = activation.getLanguageConnectionContext().getRunTimeStatisticsMode();
        this.tc = activation.getTransactionController();
        this.indexDcoci = this.tc.getDynamicCompiledConglomInfo(fkIndexConglomId);
        this.indexScoci = this.tc.getStaticCompiledConglomInfo(fkIndexConglomId);
        this.parentResultSetId = parentResultSetId;
        this.fkColArray = (int[])activation.getPreparedStatement().getSavedObject(fkColArrayItem);
        this.rowLocation = (RowLocation)activation.getPreparedStatement().getSavedObject(rltItem);
        this.numFkColumns = this.fkColArray.length;
        this.indexQualifierRow = new IndexRow(this.numFkColumns);
        this.recordConstructorTime();
    }

    private ScanController openIndexScanController(ExecRow searchRow) throws StandardException {
        this.setupQualifierRow(searchRow);
        this.indexSC = this.tc.openCompiledScan(false, 4, this.lockMode, this.isolationLevel, null, this.indexQualifierRow.getRowArray(), 1, null, this.indexQualifierRow.getRowArray(), -1, this.indexScoci, this.indexDcoci);
        return this.indexSC;
    }

    private void reopenIndexScanController(ExecRow searchRow) throws StandardException {
        this.setupQualifierRow(searchRow);
        this.indexSC.reopenScan(this.indexQualifierRow.getRowArray(), 1, null, this.indexQualifierRow.getRowArray(), -1);
    }

    private void setupQualifierRow(ExecRow searchRow) {
        DataValueDescriptor[] indexColArray = this.indexQualifierRow.getRowArray();
        DataValueDescriptor[] baseColArray = searchRow.getRowArray();
        for (int i = 0; i < this.numFkColumns; ++i) {
            indexColArray[i] = baseColArray[this.fkColArray[i] - 1];
        }
    }

    private void openIndexScan(ExecRow searchRow) throws StandardException {
        if (this.indexSC == null) {
            this.indexSC = this.openIndexScanController(searchRow);
            this.indexRow = this.indexQualifierRow.getClone();
            this.indexRow.setColumn(this.numFkColumns + 1, this.rowLocation.cloneValue(false));
        } else {
            this.reopenIndexScanController(searchRow);
        }
    }

    private ExecRow fetchIndexRow() throws StandardException {
        if (!this.indexSC.fetchNext(this.indexRow.getRowArray())) {
            return null;
        }
        return this.indexRow;
    }

    private ExecRow fetchBaseRow() throws StandardException {
        if (this.currentRow == null) {
            this.currentRow = this.getCompactRow(this.candidate, this.accessedCols, this.isKeyed);
        }
        this.baseRowLocation = (RowLocation)this.indexRow.getColumn(this.indexRow.getRowArray().length);
        boolean base_row_exists = this.heapCC.fetch(this.baseRowLocation, this.candidate.getRowArray(), this.accessedCols);
        SanityManager.ASSERT(base_row_exists, "base row disappeared.");
        return this.currentRow;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        this.beginTime = this.getCurrentTimeMillis();
        if (this.searchRow == null && (this.searchRow = this.getNextParentRow()) != null) {
            this.openIndexScan(this.searchRow);
        }
        ExecRow currentIndexRow = null;
        while (this.searchRow != null && (currentIndexRow = this.fetchIndexRow()) == null) {
            this.searchRow = this.getNextParentRow();
            if (this.searchRow == null) continue;
            this.openIndexScan(this.searchRow);
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        if (currentIndexRow != null) {
            ++this.rowsSeen;
            return this.fetchBaseRow();
        }
        return currentIndexRow;
    }

    private ExecRow getNextParentRow() throws StandardException {
        TemporaryRowHolder rowHolder;
        if (this.sourceOpened[this.sArrayIndex] == 0) {
            rowHolder = this.sourceRowHolders[this.sArrayIndex];
            this.source = (TemporaryRowHolderResultSet)rowHolder.getResultSet();
            this.source.open();
            this.sourceOpened[this.sArrayIndex] = -1;
            this.sourceResultSets[this.sArrayIndex] = this.source;
        }
        if (this.sourceOpened[this.sArrayIndex] == 1) {
            this.source = this.sourceResultSets[this.sArrayIndex];
            this.source.reStartScan(this.sourceRowHolders[this.sArrayIndex].getTemporaryConglomId(), this.sourceRowHolders[this.sArrayIndex].getPositionIndexConglomId());
            this.sourceOpened[this.sArrayIndex] = -1;
        }
        if (this.sVector.size() > this.sourceRowHolders.length) {
            this.addNewSources();
        }
        ExecRow cRow = this.source.getNextRow();
        while (cRow == null && this.sArrayIndex + 1 < this.sourceRowHolders.length) {
            ++this.sArrayIndex;
            if (this.sourceOpened[this.sArrayIndex] == 0) {
                rowHolder = this.sourceRowHolders[this.sArrayIndex];
                this.source = (TemporaryRowHolderResultSet)rowHolder.getResultSet();
                this.source.open();
                this.sourceOpened[this.sArrayIndex] = -1;
                this.sourceResultSets[this.sArrayIndex] = this.source;
            }
            if (this.sourceOpened[this.sArrayIndex] == 1) {
                this.source = this.sourceResultSets[this.sArrayIndex];
                this.source.reStartScan(this.sourceRowHolders[this.sArrayIndex].getTemporaryConglomId(), this.sourceRowHolders[this.sArrayIndex].getPositionIndexConglomId());
                this.sourceOpened[this.sArrayIndex] = -1;
            }
            cRow = this.source.getNextRow();
        }
        if (cRow == null) {
            this.sArrayIndex = 0;
            for (int i = 0; i < this.sourceOpened.length; ++i) {
                this.sourceOpened[i] = 1;
            }
        }
        return cRow;
    }

    public ConglomerateController openHeapConglomerateController() throws StandardException {
        return this.tc.openCompiledConglomerate(false, 4, this.lockMode, this.isolationLevel, this.heapScoci, this.heapDcoci);
    }

    @Override
    public void close() throws StandardException {
        if (this.runTimeStatisticsOn) {
            this.startPositionString = this.printStartPosition();
            this.stopPositionString = this.printStopPosition();
            this.scanProperties = this.getScanProperties();
        }
        if (this.indexSC != null) {
            this.indexSC.close();
            this.indexSC = null;
        }
        if (this.heapCC != null) {
            this.heapCC.close();
            this.heapCC = null;
        }
        if (this.isOpen) {
            this.source.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void finish() throws StandardException {
        if (this.source != null) {
            this.source.finish();
        }
        this.finishAndRTS();
    }

    @Override
    public void openCore() throws StandardException {
        this.initIsolationLevel();
        this.sVector = this.activation.getParentResultSet(this.parentResultSetId);
        int size = this.sVector.size();
        this.sourceRowHolders = new TemporaryRowHolder[size];
        this.sourceOpened = new int[size];
        this.sourceResultSets = new TemporaryRowHolderResultSet[size];
        for (int i = 0; i < size; ++i) {
            this.sourceRowHolders[i] = this.sVector.elementAt(i);
            this.sourceOpened[i] = 0;
        }
        this.heapCC = this.openHeapConglomerateController();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private void addNewSources() {
        int size = this.sVector.size();
        TemporaryRowHolder[] tsourceRowHolders = new TemporaryRowHolder[size];
        int[] tsourceOpened = new int[size];
        TemporaryRowHolderResultSet[] tsourceResultSets = new TemporaryRowHolderResultSet[size];
        System.arraycopy(this.sourceRowHolders, 0, tsourceRowHolders, 0, this.sourceRowHolders.length);
        System.arraycopy(this.sourceOpened, 0, tsourceOpened, 0, this.sourceOpened.length);
        System.arraycopy(this.sourceResultSets, 0, tsourceResultSets, 0, this.sourceResultSets.length);
        for (int i = this.sourceRowHolders.length; i < size; ++i) {
            tsourceRowHolders[i] = this.sVector.elementAt(i);
            tsourceOpened[i] = 0;
        }
        this.sourceRowHolders = tsourceRowHolders;
        this.sourceOpened = tsourceOpened;
        this.sourceResultSets = tsourceResultSets;
    }

    @Override
    boolean canGetInstantaneousLocks() {
        return false;
    }

    @Override
    public long getTimeSpent(int type) {
        return this.constructorTime + this.openTime + this.nextTime + this.closeTime;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        return this.baseRowLocation;
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        return this.currentRow;
    }

    public Properties getScanProperties() {
        if (this.scanProperties == null) {
            this.scanProperties = new Properties();
        }
        try {
            if (this.indexSC != null) {
                this.indexSC.getScanInfo().getAllScanInfo(this.scanProperties);
                this.coarserLock = this.indexSC.isTableLocked() && this.lockMode == 6;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return this.scanProperties;
    }

    public String printStartPosition() {
        return this.printPosition(1, this.indexQualifierRow);
    }

    public String printStopPosition() {
        return this.printPosition(-1, this.indexQualifierRow);
    }

    private String printPosition(int searchOperator, ExecIndexRow positioner) {
        String searchOp;
        String output = "";
        switch (searchOperator) {
            case 1: {
                searchOp = ">=";
                break;
            }
            case -1: {
                searchOp = ">";
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unknown search operator " + searchOperator);
                searchOp = "unknown value (" + searchOperator + ")";
            }
        }
        if (positioner != null) {
            output = output + "\t" + MessageService.getTextMessage("42Z40.U", searchOp, String.valueOf(positioner.nColumns())) + "\n";
            output = output + "\t" + MessageService.getTextMessage("42Z41.U", new Object[0]) + "\n";
            boolean colSeen = false;
            for (int position = 0; position < positioner.nColumns(); ++position) {
                if (positioner.areNullsOrdered(position)) {
                    output = output + position + " ";
                    colSeen = true;
                }
                if (!colSeen || position != positioner.nColumns() - 1) continue;
                output = output + "\n";
            }
        }
        return output;
    }

    public String printQualifiers() {
        String idt = "";
        return idt + MessageService.getTextMessage("42Z37.U", new Object[0]);
    }
}

