/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.types.BaseTypeIdImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.util.IdUtil;

public class UserDefinedTypeIdImpl
extends BaseTypeIdImpl {
    protected String className;

    public UserDefinedTypeIdImpl() {
    }

    public UserDefinedTypeIdImpl(String className) throws StandardException {
        if (className.charAt(0) == '\"') {
            String[] nameParts = IdUtil.parseMultiPartSQLIdentifier(className);
            this.schemaName = nameParts[0];
            this.unqualifiedName = nameParts[1];
            className = null;
        } else {
            this.schemaName = null;
            this.unqualifiedName = className;
            this.className = className;
        }
        this.JDBCTypeId = 2000;
    }

    public UserDefinedTypeIdImpl(String schemaName, String unqualifiedName, String className) {
        super(schemaName, unqualifiedName);
        this.className = className;
        this.JDBCTypeId = 2000;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean userType() {
        return true;
    }

    public boolean isBound() {
        return this.className != null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.className = in.readUTF();
        this.JDBCTypeId = 2000;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.className == null) {
            throw new IOException("Internal error: class name for user defined type has not been determined yet.");
        }
        out.writeUTF(this.className);
    }

    @Override
    public int getTypeFormatId() {
        return 264;
    }
}

