/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import java.io.PrintStream;
import java.lang.foreign.MemorySegment;
import org.apache.datasketches.cpc.CompressedState;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.cpc.CpcUnion;
import org.apache.datasketches.cpc.Flavor;
import org.apache.datasketches.cpc.Format;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CompressedStateTest {
    static PrintStream ps = System.out;
    long vIn = 0L;
    int lgK = 10;

    private void updateStateUnion(CpcSketch sk) {
        Format skFmt = sk.getFormat();
        CompressedState state = CompressedState.compress((CpcSketch)sk);
        Flavor f = state.getFlavor();
        Format fmt = state.getFormat();
        Assert.assertEquals((Object)fmt, (Object)skFmt);
        long c = state.numCoupons;
        MemorySegment wseg = MemorySegment.ofArray(new byte[(int)state.getRequiredSerializedBytes()]);
        state.exportToSegment(wseg);
        CompressedStateTest.printf("%8d %8d %10s %35s\n", this.vIn, c, f.toString(), fmt.toString());
        CompressedState state2 = CompressedState.importFromSegment((MemorySegment)wseg);
        CpcUnion union = new CpcUnion(this.lgK);
        union.update(sk);
        CpcSketch sk2 = union.getResult();
        skFmt = sk2.getFormat();
        state = CompressedState.compress((CpcSketch)sk2);
        f = state.getFlavor();
        fmt = state.getFormat();
        Assert.assertEquals((Object)fmt, (Object)skFmt);
        c = state.numCoupons;
        wseg = MemorySegment.ofArray(new byte[(int)state.getRequiredSerializedBytes()]);
        state.exportToSegment(wseg);
        CompressedStateTest.printf("%8d %8d %10s %35s\n", this.vIn, c, f.toString(), fmt.toString());
        state2 = CompressedState.importFromSegment((MemorySegment)wseg);
        fmt = state2.getFormat();
        Assert.assertEquals((Object)fmt, (Object)skFmt);
    }

    @Test
    public void checkLoadMemorySegment() {
        CompressedStateTest.printf("%8s %8s %10s %35s\n", "vIn", "c", "Flavor", "Format");
        CpcSketch sk = new CpcSketch(this.lgK);
        int k = 1 << this.lgK;
        this.updateStateUnion(sk);
        sk.update(++this.vIn);
        this.updateStateUnion(sk);
        while (sk.numCoupons << 5 < 3L * (long)k) {
            sk.update(++this.vIn);
        }
        this.updateStateUnion(sk);
        while (sk.numCoupons << 1 < (long)k) {
            sk.update(++this.vIn);
        }
        this.updateStateUnion(sk);
        while (sk.numCoupons << 3 < 27L * (long)k) {
            sk.update(++this.vIn);
        }
        this.updateStateUnion(sk);
    }

    @Test
    public void checkToString() {
        CpcSketch sketch = new CpcSketch(10);
        CompressedState state = CompressedState.compress((CpcSketch)sketch);
        CompressedStateTest.println(state.toString());
        sketch.update(0L);
        state = CompressedState.compress((CpcSketch)sketch);
        CompressedStateTest.println(CompressedState.toString((CompressedState)state, (boolean)true));
        for (int i = 1; i < 600; ++i) {
            sketch.update((long)i);
        }
        state = CompressedState.compress((CpcSketch)sketch);
        CompressedStateTest.println(CompressedState.toString((CompressedState)state, (boolean)true));
    }

    @Test
    public void checkIsCompressed() {
        CpcSketch sk = new CpcSketch(10);
        byte[] byteArr = sk.toByteArray();
        byteArr[5] = (byte)(byteArr[5] & 0xFFFFFFFD);
        try {
            CompressedState.importFromSegment((MemorySegment)MemorySegment.ofArray(byteArr));
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    private static void printf(String format, Object ... args) {
    }

    private static void println(String s) {
    }
}

