/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteInverseCumulativeProbabilityFunction;
import org.apache.commons.rng.sampling.distribution.SamplerBase;
import org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;

public class InverseTransformDiscreteSampler
extends SamplerBase
implements SharedStateDiscreteSampler {
    private final DiscreteInverseCumulativeProbabilityFunction function;
    private final UniformRandomProvider rng;

    public InverseTransformDiscreteSampler(UniformRandomProvider rng, DiscreteInverseCumulativeProbabilityFunction function) {
        super(null);
        this.rng = rng;
        this.function = function;
    }

    @Override
    public int sample() {
        return this.function.inverseCumulativeProbability(this.rng.nextDouble());
    }

    @Override
    public String toString() {
        return this.function.toString() + " (inverse method) [" + this.rng.toString() + "]";
    }

    @Override
    public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return new InverseTransformDiscreteSampler(rng, this.function);
    }

    public static SharedStateDiscreteSampler of(UniformRandomProvider rng, DiscreteInverseCumulativeProbabilityFunction function) {
        return new InverseTransformDiscreteSampler(rng, function);
    }
}

