/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import java.util.Arrays;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;

public class AliasMethodDiscreteSampler
implements SharedStateDiscreteSampler {
    private static final int DEFAULT_ALPHA = 0;
    private static final double ZERO = 0.0;
    private static final long ONE_AS_NUMERATOR = 0x20000000000000L;
    private static final double CONVERT_TO_NUMERATOR = 9.007199254740992E15;
    private static final int MAX_SMALL_POWER_2_SIZE = 2048;
    protected final UniformRandomProvider rng;
    protected final long[] probability;
    protected final int[] alias;

    AliasMethodDiscreteSampler(UniformRandomProvider rng, long[] probability, int[] alias) {
        this.rng = rng;
        this.probability = probability;
        this.alias = alias;
    }

    @Override
    public int sample() {
        int j = this.rng.nextInt(this.alias.length);
        if (j >= this.probability.length) {
            return this.alias[j];
        }
        return this.rng.nextLong() >>> 11 < this.probability[j] ? j : this.alias[j];
    }

    public String toString() {
        return "Alias method [" + this.rng.toString() + "]";
    }

    @Override
    public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return new AliasMethodDiscreteSampler(rng, this.probability, this.alias);
    }

    public static SharedStateDiscreteSampler of(UniformRandomProvider rng, double[] probabilities) {
        return AliasMethodDiscreteSampler.of(rng, probabilities, 0);
    }

    public static SharedStateDiscreteSampler of(UniformRandomProvider rng, double[] probabilities, int alpha) {
        double sumProb = InternalUtils.validateProbabilities(probabilities);
        int n = AliasMethodDiscreteSampler.computeSize(probabilities.length, alpha);
        double mean = sumProb / (double)n;
        int[] indices = new int[n];
        int large = n;
        int small = 0;
        for (int i = 0; i < probabilities.length; ++i) {
            if (probabilities[i] >= mean) {
                indices[--large] = i;
                continue;
            }
            indices[small++] = i;
        }
        small = AliasMethodDiscreteSampler.fillRemainingIndices(probabilities.length, indices, small);
        int nonZeroIndex = AliasMethodDiscreteSampler.findLastNonZeroIndex(probabilities);
        double[] remainingProbabilities = Arrays.copyOf(probabilities, nonZeroIndex + 1);
        long[] probability = new long[remainingProbabilities.length];
        int[] alias = new int[n];
        while (large != n && small != 0) {
            int j = indices[--small];
            int k = indices[large++];
            if (j > nonZeroIndex) {
                int n2 = k;
                remainingProbabilities[n2] = remainingProbabilities[n2] - mean;
            } else {
                double pj = remainingProbabilities[j];
                probability[j] = (long)Math.ceil(9.007199254740992E15 * (pj / mean));
                int n3 = k;
                remainingProbabilities[n3] = remainingProbabilities[n3] + (pj - mean);
            }
            alias[j] = k;
            if (remainingProbabilities[k] >= mean) {
                indices[--large] = k;
                continue;
            }
            indices[small++] = k;
        }
        AliasMethodDiscreteSampler.fillTable(probability, alias, indices, 0, small);
        AliasMethodDiscreteSampler.fillTable(probability, alias, indices, large, n);
        return AliasMethodDiscreteSampler.isSmallPowerOf2(n) ? new SmallTableAliasMethodDiscreteSampler(rng, probability, alias) : new AliasMethodDiscreteSampler(rng, probability, alias);
    }

    private static int fillRemainingIndices(int length, int[] indices, int small) {
        int updatedSmall = small;
        int i = length;
        while (i < indices.length) {
            indices[updatedSmall++] = i++;
        }
        return updatedSmall;
    }

    private static int findLastNonZeroIndex(double[] probabilities) {
        int nonZeroIndex = probabilities.length - 1;
        while (probabilities[nonZeroIndex] == 0.0) {
            --nonZeroIndex;
        }
        return nonZeroIndex;
    }

    private static int computeSize(int length, int alpha) {
        if (alpha < 0) {
            return length;
        }
        int pow2 = 32 - Integer.numberOfLeadingZeros(length - 1);
        pow2 = Math.min(30, pow2 + alpha);
        return Math.max(length, 1 << pow2);
    }

    private static void fillTable(long[] probability, int[] alias, int[] indices, int start, int end) {
        for (int i = start; i < end; ++i) {
            int index = indices[i];
            probability[index] = 0x20000000000000L;
            alias[index] = index;
        }
    }

    private static boolean isSmallPowerOf2(int n) {
        return n <= 2048 && (n & n - 1) == 0;
    }

    private static final class SmallTableAliasMethodDiscreteSampler
    extends AliasMethodDiscreteSampler {
        private final int mask;

        SmallTableAliasMethodDiscreteSampler(UniformRandomProvider rng, long[] probability, int[] alias) {
            super(rng, probability, alias);
            this.mask = alias.length - 1;
        }

        @Override
        public int sample() {
            int bits = this.rng.nextInt();
            int j = bits & this.mask;
            if (j >= this.probability.length) {
                return this.alias[j];
            }
            long longBits = (long)this.rng.nextInt() << 32 | (long)bits & 0xFFFFFFFFL;
            return longBits >>> 11 < this.probability[j] ? j : this.alias[j];
        }

        @Override
        public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new SmallTableAliasMethodDiscreteSampler(rng, this.probability, this.alias);
        }
    }
}

