/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.gamma;

import org.apache.commons.numbers.gamma.GammaException;
import org.apache.commons.numbers.gamma.LogGamma1p;

final class LogGammaSum {
    private LogGammaSum() {
    }

    static double value(double a, double b) {
        if (a < 1.0 || a > 2.0) {
            throw new GammaException("Number %s is out of range [%s, %s]", a, 1, 2);
        }
        if (b < 1.0 || b > 2.0) {
            throw new GammaException("Number %s is out of range [%s, %s]", b, 1, 2);
        }
        double x = a - 1.0 + (b - 1.0);
        if (x <= 0.5) {
            return LogGamma1p.value(1.0 + x);
        }
        if (x <= 1.5) {
            return LogGamma1p.value(x) + Math.log1p(x);
        }
        return LogGamma1p.value(x - 1.0) + Math.log(x * (1.0 + x));
    }
}

