/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.jexl342;

import java.lang.ref.Reference;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlOperator;
import org.apache.commons.jexl3.introspection.JexlMethod;
import org.apache.commons.jexl3.introspection.JexlPropertyGet;
import org.apache.commons.jexl3.introspection.JexlPropertySet;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.apache.commons.jexl3.jexl342.OptionalNullGetter;
import org.apache.commons.jexl3.jexl342.OptionalNullMethod;
import org.apache.commons.jexl3.jexl342.OptionalNullSetter;
import org.apache.commons.jexl3.jexl342.ReferenceGetExecutor;
import org.apache.commons.jexl3.jexl342.ReferenceMethodExecutor;
import org.apache.commons.jexl3.jexl342.ReferenceSetExecutor;

public class ReferenceUberspect
implements JexlUberspect {
    private final JexlUberspect uberspect;
    private final List<JexlUberspect.PropertyResolver> pojoStrategy;
    private final List<JexlUberspect.PropertyResolver> mapStrategy;
    private static final Object[] EMPTY_PARAMS = new Object[0];

    public ReferenceUberspect(JexlUberspect jexlUberspect) {
        this.uberspect = jexlUberspect;
        JexlUberspect.PropertyResolver find = new JexlUberspect.PropertyResolver(){

            public JexlPropertyGet getPropertyGet(JexlUberspect uber, Object obj, Object identifier) {
                return ReferenceUberspect.discoverFind(ReferenceUberspect.this.uberspect, obj.getClass(), identifier.toString());
            }

            public JexlPropertySet getPropertySet(JexlUberspect uber, Object obj, Object identifier, Object arg) {
                return null;
            }
        };
        this.pojoStrategy = Arrays.asList(JexlUberspect.JexlResolver.PROPERTY, find, JexlUberspect.JexlResolver.MAP, JexlUberspect.JexlResolver.LIST, JexlUberspect.JexlResolver.DUCK, JexlUberspect.JexlResolver.FIELD, JexlUberspect.JexlResolver.CONTAINER);
        this.mapStrategy = Arrays.asList(JexlUberspect.JexlResolver.MAP, JexlUberspect.JexlResolver.LIST, JexlUberspect.JexlResolver.DUCK, JexlUberspect.JexlResolver.PROPERTY, find, JexlUberspect.JexlResolver.FIELD, JexlUberspect.JexlResolver.CONTAINER);
    }

    public List<JexlUberspect.PropertyResolver> getResolvers(JexlOperator op, Object obj) {
        if (op == JexlOperator.ARRAY_GET) {
            return this.mapStrategy;
        }
        if (op == JexlOperator.ARRAY_SET) {
            return this.mapStrategy;
        }
        if (op == null && obj instanceof Map) {
            return this.mapStrategy;
        }
        return this.pojoStrategy;
    }

    private static ReferenceHandler discoverHandler(Object ref) {
        if (ref instanceof Optional) {
            return ReferenceUberspect::handleOptional;
        }
        if (ref instanceof AtomicReference) {
            return ReferenceUberspect::handleAtomic;
        }
        if (ref instanceof Reference) {
            return ReferenceUberspect::handleReference;
        }
        return null;
    }

    static Object handleOptional(Object ref) {
        Optional optional = (Optional)ref;
        return optional.isPresent() ? optional.get() : null;
    }

    static Object handleAtomic(Object ref) {
        Object obj = ((AtomicReference)ref).get();
        return obj == null ? ref : obj;
    }

    static Object handleReference(Object ref) {
        Object obj = ((Reference)ref).get();
        return obj == null ? ref : obj;
    }

    public void setClassLoader(ClassLoader loader) {
        this.uberspect.setClassLoader(loader);
    }

    public ClassLoader getClassLoader() {
        return this.uberspect.getClassLoader();
    }

    public int getVersion() {
        return this.uberspect.getVersion();
    }

    public JexlMethod getConstructor(Object ctorHandle, Object ... args) {
        return this.uberspect.getConstructor(ctorHandle, args);
    }

    public JexlMethod getMethod(Object ref, String method, Object ... args) {
        ReferenceHandler handler = ReferenceUberspect.discoverHandler(ref);
        if (handler == null) {
            return this.uberspect.getMethod(ref, method, args);
        }
        Object obj = handler.callGet(ref);
        if (ref == obj) {
            return null;
        }
        JexlMethod jexlMethod = null;
        if (obj != null) {
            jexlMethod = this.uberspect.getMethod(obj, method, args);
            if (jexlMethod == null) {
                throw new JexlException.Method(null, method, args, null);
            }
        } else {
            jexlMethod = new OptionalNullMethod(this.uberspect, method);
        }
        return new ReferenceMethodExecutor(handler, jexlMethod);
    }

    public JexlPropertyGet getPropertyGet(Object obj, Object identifier) {
        return this.getPropertyGet(null, obj, identifier);
    }

    public JexlPropertyGet getPropertyGet(List<JexlUberspect.PropertyResolver> resolvers, Object ref, Object identifier) {
        ReferenceHandler handler = ReferenceUberspect.discoverHandler(ref);
        if (handler == null) {
            return this.uberspect.getPropertyGet(resolvers, ref, identifier);
        }
        Object obj = handler.callGet(ref);
        if (ref == obj) {
            return null;
        }
        JexlPropertyGet jexlGet = null;
        if (obj != null) {
            jexlGet = this.uberspect.getPropertyGet(resolvers, obj, identifier);
            if (jexlGet == null) {
                throw new JexlException.Property(null, Objects.toString(identifier), false, null);
            }
        } else {
            jexlGet = new OptionalNullGetter(this.uberspect, identifier);
        }
        return new ReferenceGetExecutor(handler, jexlGet);
    }

    public JexlPropertySet getPropertySet(Object obj, Object identifier, Object arg) {
        return this.getPropertySet(null, obj, identifier, arg);
    }

    public JexlPropertySet getPropertySet(List<JexlUberspect.PropertyResolver> resolvers, Object ref, Object identifier, Object arg) {
        ReferenceHandler handler = ReferenceUberspect.discoverHandler(ref);
        if (handler == null) {
            return this.uberspect.getPropertySet(resolvers, ref, identifier, arg);
        }
        Object obj = handler.callGet(ref);
        if (ref == obj) {
            return null;
        }
        OptionalNullSetter jexlSet = null;
        if (obj != null) {
            jexlSet = this.uberspect.getPropertySet(resolvers, obj, identifier, arg);
            if (jexlSet == null) {
                throw new JexlException.Property(null, Objects.toString(identifier), false, null);
            }
        } else {
            jexlSet = new OptionalNullSetter(this.uberspect, identifier);
        }
        return new ReferenceSetExecutor(handler, jexlSet);
    }

    public Iterator<?> getIterator(Object ref) {
        ReferenceHandler handler = ReferenceUberspect.discoverHandler(ref);
        if (handler == null) {
            return this.uberspect.getIterator(ref);
        }
        Object obj = handler.callGet(ref);
        if (ref == obj) {
            return null;
        }
        if (obj == null) {
            return Collections.emptyIterator();
        }
        return this.uberspect.getIterator(obj);
    }

    public JexlArithmetic.Uberspect getArithmetic(JexlArithmetic arithmetic) {
        return this.uberspect.getArithmetic(arithmetic);
    }

    private static JexlPropertyGet discoverFind(JexlUberspect is, Class<?> clazz, final String property) {
        if (property == null || property.isEmpty()) {
            return null;
        }
        int start = 4;
        StringBuilder sb = new StringBuilder("find");
        sb.append(property);
        char c = sb.charAt(4);
        sb.setCharAt(4, Character.toUpperCase(c));
        JexlMethod method = is.getMethod(clazz, sb.toString(), EMPTY_PARAMS);
        if (method == null) {
            sb.setCharAt(4, Character.toLowerCase(c));
            method = is.getMethod(clazz, sb.toString(), EMPTY_PARAMS);
        }
        if (method != null && Optional.class.equals((Object)method.getReturnType())) {
            final JexlMethod getter = method;
            final String name = sb.toString();
            return new JexlPropertyGet(){

                public Object invoke(Object obj) throws Exception {
                    return getter.invoke(obj, new Object[0]);
                }

                public Object tryInvoke(Object obj, Object key) throws JexlException.TryFailed {
                    return !Objects.equals(property, key) ? JexlEngine.TRY_FAILED : getter.tryInvoke(name, obj, new Object[0]);
                }

                public boolean tryFailed(Object rval) {
                    return rval == JexlEngine.TRY_FAILED;
                }

                public boolean isCacheable() {
                    return getter.isCacheable();
                }
            };
        }
        return null;
    }

    @FunctionalInterface
    static interface ReferenceHandler {
        public Object callGet(Object var1);
    }
}

