/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.view.swing;

import java.awt.Color;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import org.scopemvc.util.ScopeConfig;

public class ValidationHelper {
    public static final Color DEFAULT_VALIDATION_FAILED_COLOR = Color.PINK;
    private String validationError;
    private JComponent parent;
    private String originalTooltipText;
    private Color originalBackground;

    public ValidationHelper(JComponent jComponent) {
        this.parent = jComponent;
    }

    public void validationFailed(Exception exception) {
        if (this.validationError == null) {
            this.originalBackground = this.parent.getBackground();
            this.originalTooltipText = this.parent.getToolTipText();
        }
        this.validationError = exception.getLocalizedMessage();
        this.parent.setBackground(this.getValidationFailedColor());
        this.parent.setToolTipText(this.validationError);
        this.clearTooltip();
    }

    public void validationSuccess() {
        if (this.validationError != null) {
            this.clearTooltip();
            this.parent.setBackground(this.originalBackground);
            this.parent.setToolTipText(this.originalTooltipText);
            this.validationError = null;
        }
    }

    public JToolTip createToolTip(JToolTip jToolTip) {
        if (jToolTip != null && this.validationError != null) {
            jToolTip.setBackground(this.getValidationFailedColor());
        }
        return jToolTip;
    }

    private Color getValidationFailedColor() {
        Object object = ScopeConfig.getObject("org.scopemvc.view.swing.ValidationHelper-validation.failed.color");
        if (object == null) {
            return DEFAULT_VALIDATION_FAILED_COLOR;
        }
        if (object instanceof Color) {
            return (Color)object;
        }
        if (object instanceof String) {
            return Color.decode((String)object);
        }
        return DEFAULT_VALIDATION_FAILED_COLOR;
    }

    private void clearTooltip() {
        ToolTipManager.sharedInstance().mousePressed(new MouseEvent(this.parent, 0, 0L, 0, 0, 0, 0, false));
    }
}

