/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.view.swing;

import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.util.convertor.StringConvertor;
import org.scopemvc.view.swing.ValidationHelper;

public abstract class STextCellEditor
extends AbstractCellEditor {
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$view$swing$STextCellEditor == null ? (class$org$scopemvc$view$swing$STextCellEditor = STextCellEditor.class$("org.scopemvc.view.swing.STextCellEditor")) : class$org$scopemvc$view$swing$STextCellEditor);
    private JTextComponent component;
    private StringConvertor convertor;
    private ValidationHelper validationHelper;
    private Object value;
    private int clickCountToStart = 2;
    static /* synthetic */ Class class$org$scopemvc$view$swing$STextCellEditor;

    public STextCellEditor(StringConvertor stringConvertor) throws IllegalArgumentException {
        if (stringConvertor == null) {
            throw new IllegalArgumentException("Passed StringConvertor cannot be null");
        }
        this.convertor = stringConvertor;
        this.component = this.createTextComponent();
        if (this.component == null) {
            throw new IllegalStateException("Method createTextComponent cannot return null component");
        }
        this.validationHelper = new ValidationHelper(this.component);
    }

    public final StringConvertor getStringConvertor() {
        return this.convertor;
    }

    public final Object getCellEditorValue() {
        return this.value;
    }

    public final int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    public final void setClickCountToStart(int n) {
        this.clickCountToStart = n;
    }

    public final void cancelCellEditing() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("cancel Editing");
        }
        this.value = null;
        super.cancelCellEditing();
    }

    public final boolean stopCellEditing() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("stop Editing");
        }
        boolean bl = this.obtainValue();
        super.stopCellEditing();
        return bl;
    }

    protected boolean isValidating() {
        return true;
    }

    protected JTextComponent getTextComponent() {
        return this.component;
    }

    protected final void setValue(Object object) throws IllegalArgumentException {
        this.component.setText(this.convertor.valueAsString(object));
    }

    protected JTextComponent createTextComponent() {
        JTextField jTextField = new JTextField(){

            public void addNotify() {
                super.addNotify();
                this.requestFocus();
            }
        };
        return jTextField;
    }

    private boolean obtainValue() {
        try {
            this.value = this.convertor.stringAsValue(this.component.getText());
            this.validationHelper.validationSuccess();
            if (LOG.isDebugEnabled()) {
                LOG.debug("cell validation succeed");
            }
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.value = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("cell validation failed");
            }
            this.validationHelper.validationFailed(illegalArgumentException);
            return !this.isValidating();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

