/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Fault;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.access.ObjectResolver;
import org.apache.cayenne.access.ParentAttachmentStrategy;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.ToStringBuilder;

class PrefetchProcessorNode
extends PrefetchTreeNode {
    List dataRows;
    List objects;
    ArcProperty incoming;
    ObjectResolver resolver;
    Map partitionByParent;
    boolean jointChildren;
    private Persistent lastResolved;
    private ParentAttachmentStrategy parentAttachmentStrategy;

    PrefetchProcessorNode(PrefetchProcessorNode parent, String segmentPath) {
        super(parent, segmentPath);
    }

    void afterInit() {
        if (this.isPartitionedByParent()) {
            this.partitionByParent = new HashMap();
        }
    }

    void linkToParent(Persistent object, Persistent parent) {
        if (parent != null && parent.getPersistenceState() != 5) {
            if (this.incoming instanceof ToOneProperty) {
                this.incoming.writePropertyDirectly(parent, null, object);
            } else {
                ArrayList<Persistent> peers = (ArrayList<Persistent>)this.partitionByParent.get(parent);
                if (peers == null) {
                    peers = new ArrayList<Persistent>();
                    this.partitionByParent.put(parent, peers);
                } else if (peers.contains(object)) {
                    return;
                }
                peers.add(object);
            }
        }
    }

    void connectToParents() {
        if (this.isPartitionedByParent()) {
            boolean parentObjectsExist;
            PrefetchProcessorNode parent = (PrefetchProcessorNode)this.getParent();
            boolean bl = parentObjectsExist = parent.getObjects() != null && parent.getObjects().size() > 0;
            if (this.incoming.getRelationship().isToMany()) {
                if (parentObjectsExist) {
                    this.connectToNodeParents(parent.getObjects());
                } else {
                    this.connectToFaultedParents();
                }
            } else if (parentObjectsExist) {
                this.clearNullRelationships(parent.getObjects());
            }
        }
    }

    private final void clearNullRelationships(List parentObjects) {
        for (Object object : parentObjects) {
            if (!(this.incoming.readPropertyDirectly(object) instanceof Fault)) continue;
            this.incoming.writePropertyDirectly(object, null, null);
        }
    }

    private final void connectToNodeParents(List parentObjects) {
        for (Persistent object : parentObjects) {
            List related = (List)this.partitionByParent.get(object);
            this.connect(object, related);
        }
    }

    private final void connectToFaultedParents() {
        for (Map.Entry entry : this.partitionByParent.entrySet()) {
            Persistent object = (Persistent)entry.getKey();
            List related = (List)entry.getValue();
            this.connect(object, related);
        }
    }

    private final void connect(Persistent object, List related) {
        if (!this.incoming.getRelationship().isToMany()) {
            throw new CayenneRuntimeException("To-one relationship wasn't handled properly: " + this.incoming.getName());
        }
        ValueHolder toManyList = (ValueHolder)this.incoming.readProperty(object);
        toManyList.setValueDirectly(related != null ? related : new ArrayList(1));
    }

    List getDataRows() {
        return this.dataRows;
    }

    List getObjects() {
        return this.objects;
    }

    void setResolver(ObjectResolver resolver) {
        this.resolver = resolver;
    }

    ObjectResolver getResolver() {
        return this.resolver;
    }

    ArcProperty getIncoming() {
        return this.incoming;
    }

    void setIncoming(ArcProperty incoming) {
        this.incoming = incoming;
    }

    void setDataRows(List dataRows) {
        this.dataRows = dataRows;
    }

    void setObjects(List objects) {
        this.objects = objects;
    }

    boolean isJointChildren() {
        return this.jointChildren;
    }

    void setJointChildren(boolean jointChildren) {
        this.jointChildren = jointChildren;
    }

    boolean isPartitionedByParent() {
        return this.parent != null;
    }

    Persistent getLastResolved() {
        return this.lastResolved;
    }

    void setLastResolved(Persistent lastResolved) {
        this.lastResolved = lastResolved;
    }

    public String toString() {
        String label = this.incoming != null ? this.incoming.getName() : "<root>";
        return new ToStringBuilder(this).append("incoming", label).append("phantom", this.phantom).toString();
    }

    ParentAttachmentStrategy getParentAttachmentStrategy() {
        return this.parentAttachmentStrategy;
    }

    void setParentAttachmentStrategy(ParentAttachmentStrategy parentAttachmentStrategy) {
        this.parentAttachmentStrategy = parentAttachmentStrategy;
    }
}

