/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.hsqldb;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.cayenne.configuration.server.DbAdapterDetector;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.hsqldb.HSQLDBAdapter;
import org.apache.cayenne.dba.hsqldb.HSQLDBNoSchemaAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;

public class HSQLDBSniffer
implements DbAdapterDetector {
    protected AdhocObjectFactory objectFactory;

    public HSQLDBSniffer(@Inject AdhocObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public DbAdapter createAdapter(DatabaseMetaData md) throws SQLException {
        String dbName = md.getDatabaseProductName();
        if (dbName == null || !dbName.toUpperCase().contains("HSQL")) {
            return null;
        }
        boolean supportsSchema = md.getDriverMajorVersion() < 1 || md.getDriverMajorVersion() == 1 && md.getDriverMinorVersion() <= 8;
        return supportsSchema ? this.objectFactory.newInstance(DbAdapter.class, HSQLDBAdapter.class.getName()) : this.objectFactory.newInstance(DbAdapter.class, HSQLDBNoSchemaAdapter.class.getName());
    }
}

