/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.access.flush.IdGenerationMarker;
import org.apache.cayenne.access.flush.operation.DbRowOp;
import org.apache.cayenne.access.flush.operation.DbRowOpVisitor;
import org.apache.cayenne.access.flush.operation.InsertDbRowOp;
import org.apache.cayenne.access.flush.operation.UpdateDbRowOp;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.NodeIdChangeOperation;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.reflect.AttributeProperty;

class ReplacementIdVisitor
implements DbRowOpVisitor<Void> {
    private final ObjectStore store;
    private final EntityResolver resolver;
    private final CompoundDiff result;

    ReplacementIdVisitor(ObjectStore store, EntityResolver resolver, CompoundDiff result) {
        this.store = store;
        this.resolver = resolver;
        this.result = result;
    }

    @Override
    public Void visitInsert(InsertDbRowOp dbRow) {
        this.updateId(dbRow);
        dbRow.getValues().getFlattenedIds().forEach((path, id) -> {
            if (id.isTemporary() && id.isReplacementIdAttached()) {
                for (Map.Entry<String, Object> next : id.getReplacementIdMap().entrySet()) {
                    if (!(next.getValue() instanceof Supplier)) continue;
                    next.setValue(((Supplier)next.getValue()).get());
                }
            } else {
                throw new CayenneRuntimeException("PK for flattened path '%s' of object %s is not set during insert.", path, dbRow.getObject());
            }
            this.store.markFlattenedPath(dbRow.getChangeId(), (String)path, id.createReplacementId());
        });
        return null;
    }

    @Override
    public Void visitUpdate(UpdateDbRowOp dbRow) {
        this.updateId(dbRow);
        return null;
    }

    private void updateId(DbRowOp dbRow) {
        ObjectId id = dbRow.getChangeId();
        Persistent object = dbRow.getObject();
        if (!id.isReplacementIdAttached()) {
            if (id == dbRow.getObject().getObjectId() && id.isTemporary()) {
                throw new CayenneRuntimeException("PK for the object %s is not set during insert.", object);
            }
            return;
        }
        Map<String, Object> replacement = id.getReplacementIdMap();
        replacement.forEach((attr, val) -> {
            if (val instanceof IdGenerationMarker) {
                throw new CayenneRuntimeException("PK for the object %s is not set during insert.", object);
            }
        });
        ObjectId replacementId = id.createReplacementId();
        if (object.getObjectId() == id && !replacementId.getEntityName().startsWith("db:")) {
            object.setObjectId(replacementId);
            for (AttributeProperty property : this.resolver.getClassDescriptor(replacementId.getEntityName()).getIdProperties()) {
                Object value;
                if (property.getAttribute() == null || (value = replacement.get(property.getAttribute().getDbAttributeName())) == null) continue;
                property.writePropertyDirectly(object, null, value);
            }
            this.result.add(new NodeIdChangeOperation((Object)id, replacementId));
        }
    }
}

