/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DeleteRule;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ObjRelationshipHandler
extends NamespaceAwareNestedTagHandler {
    public static final String OBJ_RELATIONSHIP_TAG = "obj-relationship";
    @Deprecated
    public static final String DB_RELATIONSHIP_REF_TAG = "db-relationship-ref";
    private DataMap map;
    private ObjRelationship objRelationship;

    public ObjRelationshipHandler(NamespaceAwareNestedTagHandler parentHandler, DataMap map) {
        super(parentHandler);
        this.map = map;
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) throws SAXException {
        switch (localName) {
            case "obj-relationship": {
                this.addObjRelationship(attributes);
                return true;
            }
            case "db-relationship-ref": {
                this.addDbRelationshipRef(attributes);
                return true;
            }
        }
        return false;
    }

    @Deprecated
    private void addDbRelationshipRef(Attributes attributes) throws SAXException {
        String name = attributes.getValue("name");
        if (name == null) {
            throw new SAXException("ObjRelationshipHandler::addDbRelationshipRef() - null DbRelationship name for " + this.objRelationship.getName());
        }
        String path = this.objRelationship.getDbRelationshipPath();
        this.objRelationship.setDbRelationshipPath(path != null ? path + "." + name : name);
    }

    private void addObjRelationship(Attributes attributes) throws SAXException {
        String name = attributes.getValue("name");
        if (null == name) {
            throw new SAXException("ObjRelationshipHandler::addObjRelationship() - unable to parse target.");
        }
        String sourceName = attributes.getValue("source");
        if (sourceName == null) {
            throw new SAXException("ObjRelationshipHandler::addObjRelationship() - unable to parse source.");
        }
        ObjEntity source = this.map.getObjEntity(sourceName);
        if (source == null) {
            throw new SAXException("ObjRelationshipHandler::addObjRelationship() - unable to find source " + sourceName);
        }
        this.objRelationship = new ObjRelationship(name);
        this.objRelationship.setSourceEntity(source);
        this.objRelationship.setTargetEntityName(attributes.getValue("target"));
        this.objRelationship.setDeleteRule(DeleteRule.deleteRuleForName(attributes.getValue("deleteRule")));
        this.objRelationship.setUsedForLocking("true".equalsIgnoreCase(attributes.getValue("lock")));
        this.objRelationship.setDeferredDbRelationshipPath(attributes.getValue("db-relationship-path"));
        this.objRelationship.setCollectionType(attributes.getValue("collection-type"));
        this.objRelationship.setMapKey(attributes.getValue("map-key"));
        source.addRelationship(this.objRelationship);
    }

    public ObjRelationship getObjRelationship() {
        return this.objRelationship;
    }
}

