/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerController;
import org.apache.cayenne.modeler.action.ProjectAction;
import org.apache.cayenne.modeler.action.ProjectOpener;
import org.apache.cayenne.modeler.dialog.ErrorDebugDialog;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectLoader;
import org.apache.cayenne.project.upgrade.UpgradeMetaData;
import org.apache.cayenne.project.upgrade.UpgradeService;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.URLResource;
import org.apache.cayenne.swing.control.FileMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenProjectAction
extends ProjectAction {
    private static Logger logObj = LoggerFactory.getLogger(OpenProjectAction.class);
    private static final Map<String, String> PROJECT_TO_MODELER_VERSION;
    private ProjectOpener fileChooser = new ProjectOpener();

    public static String getActionName() {
        return "Open Project";
    }

    public OpenProjectAction(Application application) {
        super(OpenProjectAction.getActionName(), application);
        this.resetClipboard();
    }

    @Override
    public String getIconName() {
        return "icon-open.png";
    }

    @Override
    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    @Override
    public void performAction(ActionEvent e) {
        if (this.getProjectController() != null && !this.checkSaveOnClose()) {
            return;
        }
        File f = null;
        if (e.getSource() instanceof FileMenuItem) {
            FileMenuItem menu = (FileMenuItem)e.getSource();
            f = menu.getFile();
        } else if (e.getSource() instanceof File) {
            f = (File)e.getSource();
        }
        if (f == null) {
            try {
                f = this.fileChooser.openProjectFile(Application.getFrame());
            }
            catch (Exception ex) {
                logObj.warn("Error loading project file.", ex);
            }
        }
        if (f != null) {
            if (this.getProjectController() != null && !this.closeProject(false)) {
                return;
            }
            this.openProject(f);
        }
        this.application.getUndoManager().discardAllEdits();
    }

    public void openProject(File file) {
        try {
            if (!file.exists()) {
                JOptionPane.showMessageDialog(Application.getFrame(), "Can't open project - file \"" + file.getPath() + "\" does not exist", "Can't Open Project", 0);
                return;
            }
            CayenneModelerController controller = Application.getInstance().getFrameController();
            controller.addToLastProjListAction(file);
            URL url = file.toURI().toURL();
            Resource rootSource = new URLResource(url);
            UpgradeService upgradeService = this.getApplication().getInjector().getInstance(UpgradeService.class);
            UpgradeMetaData metaData = upgradeService.getUpgradeType(rootSource);
            switch (metaData.getUpgradeType()) {
                case INTERMEDIATE_UPGRADE_NEEDED: {
                    String modelerVersion = PROJECT_TO_MODELER_VERSION.get(metaData.getProjectVersion());
                    if (modelerVersion == null) {
                        modelerVersion = "";
                    }
                    JOptionPane.showMessageDialog(Application.getFrame(), "Open the project in the older Modeler " + modelerVersion + " to do an intermediate upgrade\nbefore you can upgrade to latest version.", "Can't Upgrade Project", 0);
                    this.closeProject(false);
                    return;
                }
                case DOWNGRADE_NEEDED: {
                    JOptionPane.showMessageDialog(Application.getFrame(), "Can't open project - it was created using a newer version of the Modeler", "Can't Open Project", 0);
                    this.closeProject(false);
                    return;
                }
                case UPGRADE_NEEDED: {
                    if (this.processUpgrades()) {
                        rootSource = upgradeService.upgradeProject(rootSource);
                        break;
                    }
                    this.closeProject(false);
                    return;
                }
            }
            this.openProjectResourse(rootSource, controller);
        }
        catch (Exception ex) {
            logObj.warn("Error loading project file.", ex);
            ErrorDebugDialog.guiWarning(ex, "Error loading project");
        }
    }

    private Project openProjectResourse(Resource resource, CayenneModelerController controller) {
        Project project = this.getApplication().getInjector().getInstance(ProjectLoader.class).loadProject(resource);
        controller.projectOpenedAction(project);
        return project;
    }

    private boolean processUpgrades() {
        int returnCode = JOptionPane.showConfirmDialog(Application.getFrame(), "Project needs an upgrade to a newer version. Upgrade?", "Upgrade Needed", 0);
        return returnCode != 1;
    }

    private void resetClipboard() {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[0];
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return false;
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                throw new UnsupportedFlavorException(flavor);
            }
        }, null);
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1.0", "v3.0");
        map.put("1.1", "v3.0");
        map.put("1.2", "v3.0");
        map.put("2.0", "v3.0");
        map.put("3.0.0.1", "v3.1");
        PROJECT_TO_MODELER_VERSION = Collections.unmodifiableMap(map);
    }
}

