/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataDomainSyncBucket;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DbArcId;
import org.apache.cayenne.access.util.DefaultOperationObserver;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.util.HashCodeBuilder;
import org.apache.cayenne.util.Util;

final class FlattenedArcKey {
    ObjRelationship relationship;
    DbArcId id1;
    DbArcId id2;

    FlattenedArcKey(ObjectId sourceId, ObjectId destinationId, ObjRelationship relationship) {
        this.relationship = relationship;
        List<DbRelationship> dbRelationships = relationship.getDbRelationships();
        if (dbRelationships.size() != 2) {
            throw new CayenneRuntimeException("Only single-step flattened relationships are supported in this operation, whereas the relationship '%s' has %s", relationship, dbRelationships.size());
        }
        DbRelationship r1 = dbRelationships.get(0);
        DbRelationship r2 = dbRelationships.get(1).getReverseRelationship();
        if (r2 == null) {
            throw new IllegalStateException("No reverse relationship for DbRelationship " + dbRelationships.get(1));
        }
        this.id1 = new DbArcId(sourceId, r1);
        this.id2 = new DbArcId(destinationId, r2);
    }

    DbEntity getJoinEntity() {
        return this.id1.getEntity();
    }

    Map<String, Object> buildJoinSnapshotForInsert(DataNode node) {
        Map<String, Object> snapshot = this.lazyJoinSnapshot();
        boolean autoPkDone = false;
        DbEntity joinEntity = this.getJoinEntity();
        for (DbAttribute dbAttr : joinEntity.getPrimaryKeys()) {
            DbAdapter adapter;
            String dbAttrName = dbAttr.getName();
            if (snapshot.containsKey(dbAttrName) || (adapter = node.getAdapter()).supportsGeneratedKeys() && dbAttr.isGenerated()) continue;
            if (autoPkDone) {
                throw new CayenneRuntimeException("Primary Key autogeneration only works for a single attribute.", new Object[0]);
            }
            try {
                Object pkValue = adapter.getPkGenerator().generatePk(node, dbAttr);
                snapshot.put(dbAttrName, pkValue);
                autoPkDone = true;
            }
            catch (Exception ex) {
                throw new CayenneRuntimeException("Error generating PK: %s", (Throwable)ex, ex.getMessage());
            }
        }
        return snapshot;
    }

    List buildJoinSnapshotsForDelete(DataNode node) {
        int i;
        Map<String, Object> snapshot = this.eagerJoinSnapshot();
        DbEntity joinEntity = this.getJoinEntity();
        boolean fetchKey = false;
        for (DbAttribute dbAttr : joinEntity.getPrimaryKeys()) {
            String dbAttrName = dbAttr.getName();
            if (snapshot.containsKey(dbAttrName)) continue;
            fetchKey = true;
            break;
        }
        if (!fetchKey) {
            return Collections.singletonList(snapshot);
        }
        QuotingStrategy quoter = node.getAdapter().getQuotingStrategy();
        StringBuilder sql = new StringBuilder("SELECT ");
        Collection<DbAttribute> pk = joinEntity.getPrimaryKeys();
        final List<Object> pkList = pk instanceof List ? (List<Object>)pk : new ArrayList<DbAttribute>(pk);
        for (i = 0; i < pkList.size(); ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            DbAttribute attribute = (DbAttribute)pkList.get(i);
            sql.append("#result('");
            sql.append(quoter.quotedName(attribute));
            sql.append("' '").append(TypesMapping.getJavaBySqlType(attribute.getType()));
            sql.append("' '").append("pk").append(i);
            sql.append("')");
        }
        sql.append(" FROM ").append(quoter.quotedFullyQualifiedName(joinEntity)).append(" WHERE ");
        i = snapshot.size();
        for (Object e : snapshot.keySet()) {
            sql.append(quoter.quotedIdentifier(joinEntity, String.valueOf(e))).append(" #bindEqual($").append(e).append(")");
            if (--i <= 0) continue;
            sql.append(" AND ");
        }
        SQLTemplate query = new SQLTemplate(joinEntity.getDataMap(), sql.toString(), true);
        query.setParams(snapshot);
        final List[] listArray = new List[1];
        node.performQueries(Collections.singleton(query), new DefaultOperationObserver(){

            @Override
            public void nextRows(Query query, List<?> dataRows) {
                if (!dataRows.isEmpty()) {
                    ArrayList fixedRows = new ArrayList(dataRows.size());
                    for (Object o : dataRows) {
                        DataRow row = (DataRow)o;
                        DataRow fixedRow = new DataRow(2);
                        for (int i = 0; i < pkList.size(); ++i) {
                            DbAttribute attribute = (DbAttribute)pkList.get(i);
                            fixedRow.put(attribute.getName(), row.get("pk" + i));
                        }
                        fixedRows.add(fixedRow);
                    }
                    dataRows = fixedRows;
                }
                listArray[0] = dataRows;
            }

            @Override
            public void nextQueryException(Query query, Exception ex) {
                throw new CayenneRuntimeException("Raising from query exception.", Util.unwindException(ex), new Object[0]);
            }

            @Override
            public void nextGlobalException(Exception ex) {
                throw new CayenneRuntimeException("Raising from underlyingQueryEngine exception.", Util.unwindException(ex), new Object[0]);
            }
        });
        return listArray[0];
    }

    public int hashCode() {
        int compare = this.id1.getSourceId().getEntityName().compareTo(this.id2.getSourceId().getEntityName());
        if (compare == 0 && (compare = this.id1.getIncominArc().getName().compareTo(this.id2.getIncominArc().getName())) == 0) {
            ObjRelationship or2 = this.relationship.getReverseRelationship();
            compare = or2 != null ? this.relationship.getName().compareTo(or2.getName()) : 1;
        }
        Object[] ordered = compare < 0 ? new DbArcId[]{this.id1, this.id2} : new DbArcId[]{this.id2, this.id1};
        return new HashCodeBuilder().append(ordered).toHashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FlattenedArcKey)) {
            return false;
        }
        FlattenedArcKey key = (FlattenedArcKey)object;
        if (this.id1.equals(key.id1)) {
            return this.id2.equals(key.id2);
        }
        if (this.id1.equals(key.id2)) {
            return this.id2.equals(key.id1);
        }
        return false;
    }

    private Map<String, Object> eagerJoinSnapshot() {
        List<DbRelationship> relList = this.relationship.getDbRelationships();
        if (relList.size() != 2) {
            throw new CayenneRuntimeException("Only single-step flattened relationships are supported in this operation: %s", this.relationship);
        }
        DbRelationship firstDbRel = relList.get(0);
        DbRelationship secondDbRel = relList.get(1);
        Map<String, Object> sourceId = this.id1.getSourceId().getIdSnapshot();
        Map<String, Object> destinationId = this.id2.getSourceId().getIdSnapshot();
        HashMap<String, Object> snapshot = new HashMap<String, Object>(sourceId.size() + destinationId.size(), 1.0f);
        for (DbJoin join : firstDbRel.getJoins()) {
            snapshot.put(join.getTargetName(), sourceId.get(join.getSourceName()));
        }
        for (DbJoin join : secondDbRel.getJoins()) {
            snapshot.put(join.getSourceName(), destinationId.get(join.getTargetName()));
        }
        return snapshot;
    }

    private Map<String, Object> lazyJoinSnapshot() {
        DataDomainSyncBucket.PropagatedValueFactory value;
        List<DbRelationship> relList = this.relationship.getDbRelationships();
        if (relList.size() != 2) {
            throw new CayenneRuntimeException("Only single-step flattened relationships are supported in this operation: %s", this.relationship);
        }
        DbRelationship firstDbRel = relList.get(0);
        DbRelationship secondDbRel = relList.get(1);
        List<DbJoin> fromSourceJoins = firstDbRel.getJoins();
        List<DbJoin> toTargetJoins = secondDbRel.getJoins();
        HashMap<String, Object> snapshot = new HashMap<String, Object>(fromSourceJoins.size() + toTargetJoins.size(), 1.0f);
        for (DbJoin join : fromSourceJoins) {
            value = new DataDomainSyncBucket.PropagatedValueFactory(this.id1.getSourceId(), join.getSourceName());
            snapshot.put(join.getTargetName(), value);
        }
        for (DbJoin join : toTargetJoins) {
            value = new DataDomainSyncBucket.PropagatedValueFactory(this.id2.getSourceId(), join.getTargetName());
            snapshot.put(join.getSourceName(), value);
        }
        return snapshot;
    }
}

