/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataDomainFlushAction;
import org.apache.cayenne.access.DataDomainSyncBucket;
import org.apache.cayenne.access.DataNodeSyncQualifierDescriptor;
import org.apache.cayenne.access.DbEntityClassDescriptor;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.query.DeleteBatchQuery;
import org.apache.cayenne.query.Query;

class DataDomainDeleteBucket
extends DataDomainSyncBucket {
    DataDomainDeleteBucket(DataDomainFlushAction parent) {
        super(parent);
    }

    @Override
    void postprocess() {
        if (!this.objectsByDescriptor.isEmpty()) {
            Collection<ObjectId> deletedIds = this.parent.getResultDeletedIds();
            for (List objects : this.objectsByDescriptor.values()) {
                for (Persistent object : objects) {
                    deletedIds.add(object.getObjectId());
                }
            }
        }
    }

    @Override
    void appendQueriesInternal(Collection<Query> queries) {
        DataNodeSyncQualifierDescriptor qualifierBuilder = new DataNodeSyncQualifierDescriptor();
        EntitySorter sorter = this.parent.getDomain().getEntitySorter();
        sorter.sortDbEntities(this.dbEntities, true);
        for (DbEntity dbEntity : this.dbEntities) {
            Collection descriptors = (Collection)this.descriptorsByDbEntity.get(dbEntity);
            LinkedHashMap<List<Set>, DeleteBatchQuery> batches = new LinkedHashMap<List<Set>, DeleteBatchQuery>();
            for (DbEntityClassDescriptor descriptor : descriptors) {
                qualifierBuilder.reset(descriptor);
                boolean isRootDbEntity = descriptor.isMaster();
                List objects = (List)this.objectsByDescriptor.get(descriptor.getClassDescriptor());
                if (objects.isEmpty()) continue;
                this.checkReadOnly(descriptor.getEntity());
                if (isRootDbEntity) {
                    sorter.sortObjectsForEntity(descriptor.getEntity(), objects, true);
                }
                for (Persistent o : objects) {
                    ObjectDiff diff = this.parent.objectDiff(o.getObjectId());
                    Map<String, Object> qualifierSnapshot = qualifierBuilder.createQualifierSnapshot(diff);
                    HashSet<String> nullQualifierNames = new HashSet<String>();
                    for (Map.Entry<String, Object> entry : qualifierSnapshot.entrySet()) {
                        if (entry.getValue() != null) continue;
                        nullQualifierNames.add(entry.getKey());
                    }
                    List<Set> batchKey = Arrays.asList(nullQualifierNames);
                    DeleteBatchQuery batch = (DeleteBatchQuery)batches.get(batchKey);
                    if (batch == null) {
                        batch = new DeleteBatchQuery(dbEntity, qualifierBuilder.getAttributes(), nullQualifierNames, 27);
                        batch.setUsingOptimisticLocking(qualifierBuilder.isUsingOptimisticLocking());
                        batches.put(batchKey, batch);
                    }
                    batch.add(qualifierSnapshot);
                }
            }
            queries.addAll(batches.values());
        }
    }
}

