/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.upgrade;

import java.io.InputStream;
import java.net.URL;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.project.upgrade.UpgradeHandler;
import org.apache.cayenne.project.upgrade.UpgradeMetaData;
import org.apache.cayenne.project.upgrade.UpgradeType;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseUpgradeHandler
implements UpgradeHandler {
    static final String UNKNOWN_VERSION = "0";
    static final String MIN_SUPPORTED_VERSION = "3.0.0.1";
    protected Resource projectSource;
    protected UpgradeMetaData metaData;

    public BaseUpgradeHandler(Resource projectSource) {
        if (projectSource == null) {
            throw new NullPointerException("Null project source");
        }
        this.projectSource = projectSource;
    }

    protected void attachToNamespace(DataChannelDescriptor channelDescriptor) {
        EntityResolver entityResolver = new EntityResolver(channelDescriptor.getDataMaps());
        for (DataMap map : entityResolver.getDataMaps()) {
            map.setNamespace(entityResolver);
        }
    }

    @Override
    public Resource getProjectSource() {
        return this.projectSource;
    }

    @Override
    public UpgradeMetaData getUpgradeMetaData() {
        if (this.metaData == null) {
            this.metaData = this.loadMetaData();
        }
        return this.metaData;
    }

    @Override
    public Resource performUpgrade() throws ConfigurationException {
        UpgradeMetaData metaData = this.getUpgradeMetaData();
        switch (metaData.getUpgradeType()) {
            case DOWNGRADE_NEEDED: {
                throw new ConfigurationException("Downgrade can not be performed", new Object[0]);
            }
            case INTERMEDIATE_UPGRADE_NEEDED: {
                throw new ConfigurationException("Upgrade can not be performed - intermediate version upgrade needed", new Object[0]);
            }
            case UPGRADE_NEEDED: {
                return this.doPerformUpgrade(metaData);
            }
        }
        return this.getProjectSource();
    }

    protected abstract Resource doPerformUpgrade(UpgradeMetaData var1) throws ConfigurationException;

    protected abstract String getToVersion();

    protected UpgradeMetaData loadMetaData() {
        String version = this.loadProjectVersion();
        UpgradeMetaData metadata = new UpgradeMetaData();
        metadata.setSupportedVersion(this.getToVersion());
        metadata.setProjectVersion(version);
        int c1 = this.compareVersions(version, MIN_SUPPORTED_VERSION);
        int c2 = this.compareVersions(this.getToVersion(), version);
        if (c1 < 0) {
            metadata.setIntermediateUpgradeVersion(MIN_SUPPORTED_VERSION);
            metadata.setUpgradeType(UpgradeType.INTERMEDIATE_UPGRADE_NEEDED);
        } else if (c2 < 0) {
            metadata.setUpgradeType(UpgradeType.DOWNGRADE_NEEDED);
        } else if (c2 == 0) {
            metadata.setUpgradeType(UpgradeType.UPGRADE_NOT_NEEDED);
        } else {
            metadata.setUpgradeType(UpgradeType.UPGRADE_NEEDED);
        }
        return metadata;
    }

    protected String loadProjectVersion() {
        RootTagHandler rootHandler = new RootTagHandler();
        URL url = this.projectSource.getURL();
        try (InputStream in2 = url.openStream();){
            XMLReader parser = Util.createXmlReader();
            parser.setContentHandler(rootHandler);
            parser.setErrorHandler(rootHandler);
            parser.parse(new InputSource(in2));
        }
        catch (SAXException in2) {
        }
        catch (Exception e) {
            throw new ConfigurationException("Error reading configuration from %s", (Throwable)e, url);
        }
        return rootHandler.projectVersion != null ? rootHandler.projectVersion : UNKNOWN_VERSION;
    }

    protected int compareVersions(String v1, String v2) {
        double v2Double;
        if (v1.equals(v2)) {
            return 0;
        }
        double v1Double = this.decodeVersion(v1);
        return v1Double < (v2Double = this.decodeVersion(v2)) ? -1 : 1;
    }

    protected double decodeVersion(String version) {
        if (version == null || version.trim().length() == 0) {
            return 0.0;
        }
        StringBuilder buffer = new StringBuilder(version.length());
        boolean dotProcessed = false;
        for (int i = 0; i < version.length(); ++i) {
            char nextChar = version.charAt(i);
            if (nextChar == '.' && !dotProcessed) {
                dotProcessed = true;
                buffer.append('.');
                continue;
            }
            if (!Character.isDigit(nextChar)) continue;
            buffer.append(nextChar);
        }
        return Double.parseDouble(buffer.toString());
    }

    class RootTagHandler
    extends DefaultHandler {
        private String projectVersion;

        RootTagHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.projectVersion = attributes.getValue("", "project-version");
            throw new SAXException("finished");
        }
    }
}

