/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;
import org.apache.cayenne.modeler.undo.CreateRelationshipUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.util.DeleteRuleUpdater;

public class CreateRelationshipAction
extends CayenneAction {
    public CreateRelationshipAction(Application application) {
        super(CreateRelationshipAction.getActionName(), application);
    }

    public static String getActionName() {
        return "Create Relationship";
    }

    static void fireObjRelationshipEvent(Object src, ProjectController mediator, ObjEntity objEntity, ObjRelationship rel) {
        mediator.fireObjRelationshipEvent(new RelationshipEvent(src, (Relationship)rel, (Entity)objEntity, 2));
        RelationshipDisplayEvent rde = new RelationshipDisplayEvent(src, rel, (Entity)objEntity, mediator.getCurrentDataMap(), (DataChannelDescriptor)mediator.getProject().getRootNode());
        mediator.fireObjRelationshipDisplayEvent(rde);
    }

    static void fireDbRelationshipEvent(Object src, ProjectController mediator, DbEntity dbEntity, DbRelationship rel) {
        mediator.fireDbRelationshipEvent(new RelationshipEvent(src, (Relationship)rel, (Entity)dbEntity, 2));
        RelationshipDisplayEvent rde = new RelationshipDisplayEvent(src, rel, (Entity)dbEntity, mediator.getCurrentDataMap(), (DataChannelDescriptor)mediator.getProject().getRootNode());
        mediator.fireDbRelationshipDisplayEvent(rde);
    }

    @Override
    public String getIconName() {
        return "icon-relationship.png";
    }

    @Override
    public void performAction(ActionEvent e) {
        ObjEntity objEnt = this.getProjectController().getCurrentObjEntity();
        if (objEnt != null) {
            ObjRelationship rel = new ObjRelationship();
            rel.setName(NameBuilder.builder(rel, objEnt).name());
            this.createObjRelationship(objEnt, rel);
            this.application.getUndoManager().addEdit(new CreateRelationshipUndoableEdit(objEnt, new ObjRelationship[]{rel}));
        } else {
            DbEntity dbEnt = this.getProjectController().getCurrentDbEntity();
            if (dbEnt != null) {
                DbRelationship rel = new DbRelationship();
                rel.setName(NameBuilder.builder(rel, dbEnt).name());
                this.createDbRelationship(dbEnt, rel);
                this.application.getUndoManager().addEdit(new CreateRelationshipUndoableEdit(dbEnt, new DbRelationship[]{rel}));
            }
        }
    }

    public void createObjRelationship(ObjEntity objEntity, ObjRelationship rel) {
        ProjectController mediator = this.getProjectController();
        rel.setSourceEntity(objEntity);
        DeleteRuleUpdater.updateObjRelationship(rel);
        objEntity.addRelationship(rel);
        CreateRelationshipAction.fireObjRelationshipEvent(this, mediator, objEntity, rel);
    }

    public void createDbRelationship(DbEntity dbEntity, DbRelationship rel) {
        ProjectController mediator = this.getProjectController();
        rel.setSourceEntity(dbEntity);
        dbEntity.addRelationship(rel);
        CreateRelationshipAction.fireDbRelationshipEvent(this, mediator, dbEntity, rel);
    }

    @Override
    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Relationship) {
            return ((Relationship)((Object)object)).getParent() != null && ((Relationship)((Object)object)).getParent() instanceof Entity;
        }
        return false;
    }
}

