/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge;

import java.util.Collection;
import java.util.TreeSet;
import org.apache.cayenne.dbsync.merge.MergerDictionary;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;

class DbRelationshipDictionary
extends MergerDictionary<DbRelationship> {
    private final DbEntity container;

    DbRelationshipDictionary(DbEntity container) {
        this.container = container;
    }

    @Override
    String getName(DbRelationship entity) {
        return new Signature(entity).getName();
    }

    @Override
    Collection<DbRelationship> getAll() {
        return this.container.getRelationships();
    }

    private static class Signature {
        private final DbRelationship relationship;
        private String[] joinSignature;

        private Signature(DbRelationship relationship) {
            this.relationship = relationship;
            this.build();
        }

        public String getName() {
            if (this.joinSignature.length == 0) {
                return "";
            }
            String name = this.joinSignature[0];
            for (int i = 1; i < this.joinSignature.length; ++i) {
                name = name + "|" + this.joinSignature[i];
            }
            return name;
        }

        private void build() {
            TreeSet<String> joins = new TreeSet<String>();
            for (DbJoin join : this.relationship.getJoins()) {
                joins.add(this.relationship.getSourceEntityName() + "." + join.getSourceName() + ">" + this.relationship.getTargetEntityName() + "." + join.getTargetName());
            }
            this.joinSignature = joins.toArray(new String[0]);
        }
    }
}

