/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.rop;

import java.util.Map;

public class ROPUtil {
    public static String getLogConnect(String url, String username, boolean password) {
        return ROPUtil.getLogConnect(url, username, password, null);
    }

    public static String getLogConnect(String url, String username, boolean password, String sharedSessionName) {
        StringBuilder log = new StringBuilder("Connecting to [");
        if (username != null) {
            log.append(username);
            if (password) {
                log.append(":*******");
            }
            log.append("@");
        }
        log.append(url);
        log.append("]");
        if (sharedSessionName != null) {
            log.append(" - shared session '").append(sharedSessionName).append("'");
        } else {
            log.append(" - dedicated session.");
        }
        return log.toString();
    }

    public static String getLogDisconnect(String url, String username, boolean password) {
        StringBuilder log = new StringBuilder("Disconnecting from [");
        if (username != null) {
            log.append(username);
            if (password) {
                log.append(":*******");
            }
            log.append("@");
        }
        log.append(url);
        log.append("]");
        return log.toString();
    }

    public static String getParamsAsString(Map<String, String> params) {
        StringBuilder urlParams = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (urlParams.length() > 0) {
                urlParams.append('&');
            }
            urlParams.append(entry.getKey());
            urlParams.append('=');
            urlParams.append(entry.getValue());
        }
        return urlParams.toString();
    }

    public static String getBasicAuth(String username, String password) {
        if (username != null && password != null) {
            return "Basic " + ROPUtil.base64(username + ":" + password);
        }
        return null;
    }

    public static String base64(String value) {
        long chunk;
        StringBuffer cb = new StringBuffer();
        int i = 0;
        i = 0;
        while (i + 2 < value.length()) {
            chunk = value.charAt(i);
            chunk = (chunk << 8) + (long)value.charAt(i + 1);
            chunk = (chunk << 8) + (long)value.charAt(i + 2);
            cb.append(ROPUtil.encode(chunk >> 18));
            cb.append(ROPUtil.encode(chunk >> 12));
            cb.append(ROPUtil.encode(chunk >> 6));
            cb.append(ROPUtil.encode(chunk));
            i += 3;
        }
        if (i + 1 < value.length()) {
            chunk = value.charAt(i);
            chunk = (chunk << 8) + (long)value.charAt(i + 1);
            cb.append(ROPUtil.encode((chunk <<= 8) >> 18));
            cb.append(ROPUtil.encode(chunk >> 12));
            cb.append(ROPUtil.encode(chunk >> 6));
            cb.append('=');
        } else if (i < value.length()) {
            chunk = value.charAt(i);
            cb.append(ROPUtil.encode((chunk <<= 16) >> 18));
            cb.append(ROPUtil.encode(chunk >> 12));
            cb.append('=');
            cb.append('=');
        }
        return cb.toString();
    }

    public static char encode(long d) {
        if ((d &= 0x3FL) < 26L) {
            return (char)(d + 65L);
        }
        if (d < 52L) {
            return (char)(d + 97L - 26L);
        }
        if (d < 62L) {
            return (char)(d + 48L - 52L);
        }
        if (d == 62L) {
            return '+';
        }
        return '/';
    }
}

