/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.hsqldb;

import java.sql.Connection;
import org.apache.cayenne.access.jdbc.ProcedureAction;
import org.apache.cayenne.access.trans.ProcedureTranslator;
import org.apache.cayenne.dba.JdbcActionBuilder;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.hsqldb.HSQLDBProcedureTranslator;
import org.apache.cayenne.dba.hsqldb.HSQLSelectAction;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SelectQuery;

class HSQLActionBuilder
extends JdbcActionBuilder {
    HSQLActionBuilder(JdbcAdapter adapter, EntityResolver resolver) {
        super(adapter, resolver);
    }

    public SQLAction objectSelectAction(SelectQuery query) {
        return new HSQLSelectAction(query, this.adapter, this.entityResolver);
    }

    public SQLAction procedureAction(ProcedureQuery query) {
        return new ProcedureAction(query, this.adapter, this.entityResolver){

            protected ProcedureTranslator createTranslator(Connection connection) {
                HSQLDBProcedureTranslator transl = new HSQLDBProcedureTranslator();
                transl.setAdapter(this.getAdapter());
                transl.setQuery(this.query);
                transl.setEntityResolver(this.getEntityResolver());
                transl.setConnection(connection);
                transl.setJdbcEventLogger(HSQLActionBuilder.this.logger);
                return transl;
            }
        };
    }
}

