/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class ProcedureQueryValidator
extends ConfigurationNodeValidator {
    ProcedureQueryValidator() {
    }

    void validate(ProcedureQuery query, ValidationResult validationResult) {
        this.validateName(query, validationResult);
        this.validateRoot(query, validationResult);
    }

    void validateRoot(ProcedureQuery query, ValidationResult validationResult) {
        DataMap map = query.getDataMap();
        Object root = query.getRoot();
        if (root == null && map != null) {
            this.addFailure(validationResult, query, "ProcedureQuery '%s' has no root", query.getName());
        }
        if (root instanceof Procedure) {
            Procedure procedure = (Procedure)root;
            if (map != null && map.getProcedure(procedure.getName()) != procedure) {
                this.addFailure(validationResult, query, "ProcedureQuery '%s' has invalid Procedure root: %s", query.getName(), procedure.getName());
            }
            return;
        }
        if (root instanceof String && map != null && map.getProcedure(root.toString()) == null) {
            this.addFailure(validationResult, query, "ProcedureQuery '%s' has invalid Procedure root: %s", query.getName(), root);
        }
    }

    void validateName(ProcedureQuery query, ValidationResult validationResult) {
        String name = query.getName();
        if (Util.isEmptyString(name)) {
            this.addFailure(validationResult, query, "Unnamed ProcedureQuery", new Object[0]);
            return;
        }
        DataMap map = query.getDataMap();
        if (map == null) {
            return;
        }
        for (Query otherQuery : map.getQueries()) {
            if (otherQuery == query || !name.equals(otherQuery.getName())) continue;
            this.addFailure(validationResult, query, "Dulicate ProcedureQuery name: %s", name);
            break;
        }
    }
}

