/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlite;

import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.sqlite.SQLiteActionBuilder;
import org.apache.cayenne.dba.sqlite.SQLiteBigDecimalType;
import org.apache.cayenne.dba.sqlite.SQLiteByteArrayType;
import org.apache.cayenne.dba.sqlite.SQLiteCalendarType;
import org.apache.cayenne.dba.sqlite.SQLiteDateType;
import org.apache.cayenne.dba.sqlite.SQLiteFloatType;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteAdapter
extends JdbcAdapter {
    public SQLiteAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories);
        this.setSupportsUniqueConstraints(false);
        this.setSupportsGeneratedKeys(true);
    }

    @Override
    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new SQLiteDateType());
        map.registerType(new SQLiteBigDecimalType());
        map.registerType(new SQLiteFloatType());
        map.registerType(new SQLiteByteArrayType());
        map.registerType(new SQLiteCalendarType(GregorianCalendar.class));
        map.registerType(new SQLiteCalendarType(Calendar.class));
    }

    @Override
    public String createFkConstraint(DbRelationship rel) {
        return null;
    }

    @Override
    public String createUniqueConstraint(DbEntity source, Collection<DbAttribute> columns) {
        return null;
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new SQLiteActionBuilder(this, node.getEntityResolver()));
    }

    @Override
    public void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        super.createTableAppendColumn(sqlBuffer, column);
        DbEntity entity = (DbEntity)column.getEntity();
        if (column.isGenerated() && column.isPrimaryKey() && entity.getPrimaryKeys().size() == 1) {
            sqlBuffer.append(" PRIMARY KEY AUTOINCREMENT");
        }
    }

    @Override
    protected void createTableAppendPKClause(StringBuffer sqlBuffer, DbEntity entity) {
        DbAttribute column;
        if (entity.getPrimaryKeys().size() == 1 && (column = entity.getPrimaryKeys().iterator().next()).isGenerated()) {
            return;
        }
        super.createTableAppendPKClause(sqlBuffer, entity);
    }
}

