/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.storage.jdbc.PersistentStorageManager;

public class PersistentBeanMgr {
    Log log = LogFactory.getLog(this.getClass());
    PersistentStorageManager pmgr = null;

    public PersistentBeanMgr(PersistentStorageManager pmgr) {
        this.pmgr = pmgr;
    }

    public Connection getDbConnection() {
        return this.pmgr.getDbConnection();
    }

    protected Object getObject(ResultSet rs, String field) throws Exception {
        InputStream bs = rs.getBinaryStream(field);
        if (bs == null) {
            return null;
        }
        return new ObjectInputStream(bs).readObject();
    }

    protected ByteArrayInputStream serialize(Object obj) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return bais;
    }
}

