/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.spnego;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.spnego.SpnegoClientAction;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class DefaultSpnegoClientAction
implements SpnegoClientAction {
    private static Log log = LogFactory.getLog(DefaultSpnegoClientAction.class);
    private String serviceName;
    private GSSContext secContext;
    private boolean mutualAuth;
    private boolean isUsernameServiceNameForm;

    public void setMutualAuth(boolean mutualAuthentication) {
        this.mutualAuth = mutualAuthentication;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public byte[] run() {
        try {
            GSSManager gssManager = GSSManager.getInstance();
            Oid oid = new Oid("1.3.6.1.5.5.2");
            GSSName gssService = gssManager.createName(this.serviceName, this.isUsernameServiceNameForm ? GSSName.NT_USER_NAME : GSSName.NT_HOSTBASED_SERVICE);
            this.secContext = gssManager.createContext(gssService, oid, null, 0);
            this.secContext.requestMutualAuth(this.mutualAuth);
            this.secContext.requestCredDeleg(Boolean.FALSE);
            byte[] token = new byte[]{};
            return this.secContext.initSecContext(token, 0, token.length);
        }
        catch (GSSException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error in obtaining a Kerberos token", (Throwable)e);
            }
            return null;
        }
    }

    public GSSContext getContext() {
        return this.secContext;
    }

    public void setUserNameServiceForm(boolean isUsernameServiceNameForm) {
        this.isUsernameServiceNameForm = isUsernameServiceNameForm;
    }
}

