/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.soap.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.soap.soap11.ActorBearing;
import org.opensaml.ws.soap.soap11.Detail;
import org.opensaml.ws.soap.soap11.EncodingStyleBearing;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.ws.soap.soap11.Fault;
import org.opensaml.ws.soap.soap11.FaultActor;
import org.opensaml.ws.soap.soap11.FaultCode;
import org.opensaml.ws.soap.soap11.FaultString;
import org.opensaml.ws.soap.soap11.Header;
import org.opensaml.ws.soap.soap11.MustUnderstandBearing;
import org.opensaml.ws.soap.soap12.RelayBearing;
import org.opensaml.ws.soap.soap12.RoleBearing;
import org.opensaml.xml.AttributeExtensibleXMLObject;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.schema.XSBooleanValue;
import org.opensaml.xml.util.AttributeMap;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SOAPHelper {
    private SOAPHelper() {
    }

    public static void addSOAP11MustUnderstandAttribute(XMLObject soapObject, boolean mustUnderstand) {
        if (soapObject instanceof MustUnderstandBearing) {
            ((MustUnderstandBearing)soapObject).setSOAP11MustUnderstand(new XSBooleanValue(Boolean.valueOf(mustUnderstand), true));
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().put(MustUnderstandBearing.SOAP11_MUST_UNDERSTAND_ATTR_NAME, new XSBooleanValue(Boolean.valueOf(mustUnderstand), true).toString());
        } else {
            throw new IllegalArgumentException("Specified object was neither MustUnderBearing nor AttributeExtensible");
        }
    }

    public static boolean getSOAP11MustUnderstandAttribute(XMLObject soapObject) {
        Object value;
        if (soapObject instanceof MustUnderstandBearing && (value = ((MustUnderstandBearing)soapObject).isSOAP11MustUnderstandXSBoolean()) != null) {
            return value.getValue();
        }
        if (soapObject instanceof AttributeExtensibleXMLObject) {
            value = DatatypeHelper.safeTrimOrNullString((String)((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().get((Object)MustUnderstandBearing.SOAP11_MUST_UNDERSTAND_ATTR_NAME));
            return DatatypeHelper.safeEquals((Object)"1", (Object)value);
        }
        return false;
    }

    public static void addSOAP11ActorAttribute(XMLObject soapObject, String actorURI) {
        if (soapObject instanceof ActorBearing) {
            ((ActorBearing)soapObject).setSOAP11Actor(actorURI);
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().put(ActorBearing.SOAP11_ACTOR_ATTR_NAME, actorURI);
        } else {
            throw new IllegalArgumentException("Specified object was neither ActorBearing nor AttributeExtensible");
        }
    }

    public static String getSOAP11ActorAttribute(XMLObject soapObject) {
        String value = null;
        if (soapObject instanceof ActorBearing && (value = DatatypeHelper.safeTrimOrNullString((String)((ActorBearing)soapObject).getSOAP11Actor())) != null) {
            return value;
        }
        if (soapObject instanceof AttributeExtensibleXMLObject) {
            value = DatatypeHelper.safeTrimOrNullString((String)((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().get((Object)ActorBearing.SOAP11_ACTOR_ATTR_NAME));
            return value;
        }
        return null;
    }

    public static void addSOAP11EncodingStyle(XMLObject soapObject, String encodingStyle) {
        if (soapObject instanceof EncodingStyleBearing) {
            EncodingStyleBearing esb = (EncodingStyleBearing)soapObject;
            LazyList list = esb.getSOAP11EncodingStyles();
            if (list == null) {
                list = new LazyList();
                esb.setSOAP11EncodingStyles((List<String>)list);
            }
            list.add((String)encodingStyle);
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            AttributeMap am = ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes();
            String list = am.get((Object)EncodingStyleBearing.SOAP11_ENCODING_STYLE_ATTR_NAME);
            list = list == null ? encodingStyle : list + " " + encodingStyle;
            am.put(EncodingStyleBearing.SOAP11_ENCODING_STYLE_ATTR_NAME, list);
        } else {
            throw new IllegalArgumentException("Specified object was neither EncodingStyleBearing nor AttributeExtensible");
        }
    }

    public static void addSOAP11EncodingStyles(XMLObject soapObject, List<String> encodingStyles) {
        if (soapObject instanceof EncodingStyleBearing) {
            ((EncodingStyleBearing)soapObject).setSOAP11EncodingStyles(encodingStyles);
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().put(EncodingStyleBearing.SOAP11_ENCODING_STYLE_ATTR_NAME, DatatypeHelper.listToStringValue(encodingStyles, (String)" "));
        } else {
            throw new IllegalArgumentException("Specified object was neither EncodingStyleBearing nor AttributeExtensible");
        }
    }

    public static List<String> getSOAP11EncodingStyles(XMLObject soapObject) {
        Object value;
        if (soapObject instanceof EncodingStyleBearing && (value = ((EncodingStyleBearing)soapObject).getSOAP11EncodingStyles()) != null) {
            return value;
        }
        if (soapObject instanceof AttributeExtensibleXMLObject && (value = DatatypeHelper.safeTrimOrNullString((String)((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().get((Object)EncodingStyleBearing.SOAP11_ENCODING_STYLE_ATTR_NAME))) != null) {
            DatatypeHelper.stringToList((String)value, (String)" \n\r\t");
        }
        return null;
    }

    public static void addSOAP12EncodingStyleAttribute(XMLObject soapObject, String style) {
        if (soapObject instanceof org.opensaml.ws.soap.soap12.EncodingStyleBearing) {
            ((org.opensaml.ws.soap.soap12.EncodingStyleBearing)soapObject).setSOAP12EncodingStyle(style);
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().put(org.opensaml.ws.soap.soap12.EncodingStyleBearing.SOAP12_ENCODING_STYLE_ATTR_NAME, style);
        } else {
            throw new IllegalArgumentException("Specified object was neither EncodingStyleBearing nor AttribtueExtensible");
        }
    }

    public static String getSOAP12EncodingStyleAttribute(XMLObject soapObject) {
        String style = null;
        if (soapObject instanceof org.opensaml.ws.soap.soap12.EncodingStyleBearing) {
            style = ((org.opensaml.ws.soap.soap12.EncodingStyleBearing)soapObject).getSOAP12EncodingStyle();
        }
        if (style == null && soapObject instanceof AttributeExtensibleXMLObject) {
            style = DatatypeHelper.safeTrimOrNullString((String)((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().get((Object)org.opensaml.ws.soap.soap12.EncodingStyleBearing.SOAP12_ENCODING_STYLE_ATTR_NAME));
        }
        return style;
    }

    public static void addSOAP12MustUnderstandAttribute(XMLObject soapObject, boolean mustUnderstand) {
        if (soapObject instanceof org.opensaml.ws.soap.soap12.MustUnderstandBearing) {
            ((org.opensaml.ws.soap.soap12.MustUnderstandBearing)soapObject).setSOAP12MustUnderstand(new XSBooleanValue(Boolean.valueOf(mustUnderstand), false));
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().put(org.opensaml.ws.soap.soap12.MustUnderstandBearing.SOAP12_MUST_UNDERSTAND_ATTR_NAME, new XSBooleanValue(Boolean.valueOf(mustUnderstand), false).toString());
        } else {
            throw new IllegalArgumentException("Specified object was neither MustUnderstandBearing nor AttributeExtensible");
        }
    }

    public static boolean getSOAP12MustUnderstandAttribute(XMLObject soapObject) {
        Object value;
        if (soapObject instanceof org.opensaml.ws.soap.soap12.MustUnderstandBearing && (value = ((org.opensaml.ws.soap.soap12.MustUnderstandBearing)soapObject).isSOAP12MustUnderstandXSBoolean()) != null) {
            return value.getValue();
        }
        if (soapObject instanceof AttributeExtensibleXMLObject) {
            value = DatatypeHelper.safeTrimOrNullString((String)((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().get((Object)org.opensaml.ws.soap.soap12.MustUnderstandBearing.SOAP12_MUST_UNDERSTAND_ATTR_NAME));
            return DatatypeHelper.safeEquals((Object)"1", (Object)value) || DatatypeHelper.safeEquals((Object)"true", (Object)value);
        }
        return false;
    }

    public static void addSOAP12RelayAttribute(XMLObject soapObject, boolean relay) {
        if (soapObject instanceof RelayBearing) {
            ((RelayBearing)soapObject).setSOAP12Relay(new XSBooleanValue(Boolean.valueOf(relay), false));
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().put(RelayBearing.SOAP12_RELAY_ATTR_NAME, new XSBooleanValue(Boolean.valueOf(relay), false).toString());
        } else {
            throw new IllegalArgumentException("Specified object was neither RelyBearing nor AttributeExtensible");
        }
    }

    public static boolean getSOAP12RelayAttribute(XMLObject soapObject) {
        Object value;
        if (soapObject instanceof RelayBearing && (value = ((RelayBearing)soapObject).isSOAP12RelayXSBoolean()) != null) {
            return value.getValue();
        }
        if (soapObject instanceof AttributeExtensibleXMLObject) {
            value = DatatypeHelper.safeTrimOrNullString((String)((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().get((Object)"relay"));
            return DatatypeHelper.safeEquals((Object)"1", (Object)value) || DatatypeHelper.safeEquals((Object)"true", (Object)value);
        }
        return false;
    }

    public static void addSOAP12RoleAttribute(XMLObject soapObject, String role) {
        if (soapObject instanceof RoleBearing) {
            ((RoleBearing)soapObject).setSOAP12Role(role);
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().put(RoleBearing.SOAP12_ROLE_ATTR_NAME, role);
        } else {
            throw new IllegalArgumentException("Specified object was neither RoleBearing nor AttribtueExtensible");
        }
    }

    public static String getSOAP12RoleAttribute(XMLObject soapObject) {
        String role = null;
        if (soapObject instanceof RoleBearing) {
            role = ((RoleBearing)soapObject).getSOAP12Role();
        }
        if (role == null && soapObject instanceof AttributeExtensibleXMLObject) {
            role = DatatypeHelper.safeTrimOrNullString((String)((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().get((Object)"role"));
        }
        return role;
    }

    public static void addActorAttribute(XMLObject soapObject, String actorURI) {
        SOAPHelper.addSOAP11ActorAttribute(soapObject, actorURI);
    }

    public static void addEncodingStyle(XMLObject soapObject, String encodingStyle) {
        SOAPHelper.addSOAP11EncodingStyle(soapObject, encodingStyle);
    }

    public static void addEncodingStyles(XMLObject soapObject, List<String> encodingStyles) {
        SOAPHelper.addSOAP11EncodingStyles(soapObject, encodingStyles);
    }

    public static void addMustUnderstandAttribute(XMLObject soapObject, boolean mustUnderstand) {
        SOAPHelper.addSOAP11MustUnderstandAttribute(soapObject, mustUnderstand);
    }

    public static void addHeaderBlock(MessageContext messageContext, XMLObject headerBlock) {
        XMLObject outboundEnvelope = messageContext.getOutboundMessage();
        if (outboundEnvelope == null) {
            throw new IllegalArgumentException("Message context does not contain a SOAP envelope");
        }
        if (outboundEnvelope instanceof Envelope) {
            SOAPHelper.addSOAP11HeaderBlock((Envelope)outboundEnvelope, headerBlock);
        }
    }

    public static void addSOAP11HeaderBlock(Envelope envelope, XMLObject headerBlock) {
        Header envelopeHeader = envelope.getHeader();
        if (envelopeHeader == null) {
            envelopeHeader = (Header)Configuration.getBuilderFactory().getBuilder(Header.DEFAULT_ELEMENT_NAME).buildObject(Header.DEFAULT_ELEMENT_NAME);
            envelope.setHeader(envelopeHeader);
        }
        envelopeHeader.getUnknownXMLObjects().add(headerBlock);
    }

    public static List<XMLObject> getInboundHeaderBlock(MessageContext msgContext, QName headerName, Set<String> targetNodes, boolean isFinalDestination) {
        XMLObject inboundEnvelope = msgContext.getInboundMessage();
        if (inboundEnvelope == null) {
            throw new IllegalArgumentException("Message context does not contain an inbound SOAP envelope");
        }
        if (inboundEnvelope instanceof Envelope) {
            return SOAPHelper.getSOAP11HeaderBlock((Envelope)inboundEnvelope, headerName, targetNodes, isFinalDestination);
        }
        return Collections.emptyList();
    }

    public static List<XMLObject> getOutboundHeaderBlock(MessageContext msgContext, QName headerName, Set<String> targetNodes, boolean isFinalDestination) {
        XMLObject outboundEnvelope = msgContext.getOutboundMessage();
        if (outboundEnvelope == null) {
            throw new IllegalArgumentException("Message context does not contain an outbound SOAP envelope");
        }
        if (outboundEnvelope instanceof Envelope) {
            return SOAPHelper.getSOAP11HeaderBlock((Envelope)outboundEnvelope, headerName, targetNodes, isFinalDestination);
        }
        return Collections.emptyList();
    }

    public static List<XMLObject> getSOAP11HeaderBlock(Envelope envelope, QName headerName, Set<String> targetNodes, boolean isFinalDestination) {
        Header envelopeHeader = envelope.getHeader();
        if (envelopeHeader == null) {
            return Collections.emptyList();
        }
        ArrayList<XMLObject> headers = new ArrayList<XMLObject>();
        for (XMLObject header : envelopeHeader.getUnknownXMLObjects(headerName)) {
            if (!SOAPHelper.isSOAP11HeaderTargetedToNode(header, targetNodes, isFinalDestination)) continue;
            headers.add(header);
        }
        return headers;
    }

    public static boolean isSOAP11HeaderTargetedToNode(XMLObject header, Set<String> nodeActors, boolean isFinalDestination) {
        String headerActor = SOAPHelper.getSOAP11ActorAttribute(header);
        if (headerActor == null) {
            if (isFinalDestination) {
                return true;
            }
        } else {
            if ("http://schemas.xmlsoap.org/soap/actor/next".equals(headerActor)) {
                return true;
            }
            if (nodeActors != null && nodeActors.contains(headerActor)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isInboundSOAPMessage(MessageContext messageContext) {
        XMLObject inboundMessage = messageContext.getInboundMessage();
        if (inboundMessage == null) {
            return false;
        }
        return inboundMessage instanceof Envelope;
    }

    public static Fault buildSOAP11Fault(QName faultCode, String faultString, String faultActor, List<XMLObject> detailChildren, Map<QName, String> detailAttributes) {
        if (faultCode == null) {
            throw new IllegalArgumentException("Argument for 'faultcode' may not be null");
        }
        if (faultString == null) {
            throw new IllegalArgumentException("Argument for 'faultstring' may not be null");
        }
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        Fault faultObj = (Fault)builderFactory.getBuilder(Fault.DEFAULT_ELEMENT_NAME).buildObject(Fault.DEFAULT_ELEMENT_NAME);
        FaultCode faultCodeObj = (FaultCode)builderFactory.getBuilder(FaultCode.DEFAULT_ELEMENT_NAME).buildObject(FaultCode.DEFAULT_ELEMENT_NAME);
        FaultString faultStringObj = (FaultString)builderFactory.getBuilder(FaultString.DEFAULT_ELEMENT_NAME).buildObject(FaultString.DEFAULT_ELEMENT_NAME);
        faultCodeObj.setValue(faultCode);
        faultObj.setCode(faultCodeObj);
        faultStringObj.setValue(faultString);
        faultObj.setMessage(faultStringObj);
        if (faultActor != null) {
            FaultActor faultActorObj = (FaultActor)builderFactory.getBuilder(FaultActor.DEFAULT_ELEMENT_NAME).buildObject(FaultActor.DEFAULT_ELEMENT_NAME);
            faultActorObj.setValue(faultActor);
            faultObj.setActor(faultActorObj);
        }
        Detail detailObj = null;
        if (detailChildren != null && !detailChildren.isEmpty()) {
            detailObj = (Detail)builderFactory.getBuilder(Detail.DEFAULT_ELEMENT_NAME).buildObject(Detail.DEFAULT_ELEMENT_NAME);
            for (XMLObject xo : detailChildren) {
                if (xo == null) continue;
                detailObj.getUnknownXMLObjects().add(xo);
            }
        }
        if (detailAttributes != null && !detailAttributes.isEmpty()) {
            if (detailObj == null) {
                detailObj = (Detail)builderFactory.getBuilder(Detail.DEFAULT_ELEMENT_NAME).buildObject(Detail.DEFAULT_ELEMENT_NAME);
            }
            for (Map.Entry<QName, String> entry : detailAttributes.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                detailObj.getUnknownAttributes().put(entry.getKey(), entry.getValue());
            }
        }
        if (!(detailObj == null || detailObj.getUnknownXMLObjects().isEmpty() && detailObj.getUnknownAttributes().isEmpty())) {
            faultObj.setDetail(detailObj);
        }
        return faultObj;
    }
}

