/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.mime;

import java.text.ParseException;

final class ContentTypeTokenizer {
    private static final String whitespace = " \t\n\r";
    private static final String tspecials = "()<>@,;:\\\"/[]?=";
    private final String s;
    private int index;

    public ContentTypeTokenizer(String s) {
        this.s = s;
    }

    private void skipWhiteSpace() {
        int len = this.s.length();
        while (this.index < len && whitespace.indexOf(this.s.charAt(this.index)) != -1) {
            ++this.index;
        }
    }

    String expectToken() throws ParseException {
        int end;
        this.skipWhiteSpace();
        int begin = this.index;
        int len = this.s.length();
        while (this.index < len && tspecials.indexOf(this.s.charAt(this.index)) == -1) {
            ++this.index;
        }
        for (end = this.index; end > begin && whitespace.indexOf(this.s.charAt(end - 1)) != -1; --end) {
        }
        if (begin == end) {
            if (this.index == this.s.length()) {
                return null;
            }
            throw new ParseException("Expected token, but found '" + this.s.charAt(this.index) + "'", this.index);
        }
        return this.s.substring(begin, end);
    }

    String requireToken() throws ParseException {
        String token = this.expectToken();
        if (token == null) {
            throw new ParseException("Token expected", this.index);
        }
        return token;
    }

    String requireTokenOrQuotedString() throws ParseException {
        this.skipWhiteSpace();
        int len = this.s.length();
        if (this.index < len) {
            if (this.s.charAt(this.index) == '\"') {
                StringBuffer sb = new StringBuffer();
                ++this.index;
                while (this.index < len) {
                    char c = this.s.charAt(this.index);
                    if (c == '\\') {
                        ++this.index;
                        if (this.index == len) {
                            throw new ParseException("Expected more input after escape character", this.index);
                        }
                        sb.append(this.s.charAt(this.index));
                    } else {
                        if (c == '\"') break;
                        sb.append(c);
                    }
                    ++this.index;
                }
                if (this.index == len) {
                    throw new ParseException("Unclosed quoted string", this.index);
                }
                ++this.index;
                this.skipWhiteSpace();
                return sb.toString();
            }
            return this.requireToken();
        }
        throw new ParseException("Unexpected end of string; expected token or quoted string", this.index);
    }

    boolean expect(char c) throws ParseException {
        if (this.index == this.s.length()) {
            return false;
        }
        char actual = this.s.charAt(this.index);
        if (actual == c) {
            ++this.index;
            return true;
        }
        throw new ParseException("Expected '" + c + "' instead of '" + actual + "'", this.index);
    }

    void require(char c) throws ParseException {
        if (!this.expect(c)) {
            throw new ParseException("Unexpected end of string; expected '" + c + "'", this.index);
        }
    }

    void requireEndOfString() throws ParseException {
        if (this.index != this.s.length()) {
            throw new ParseException("Unexpected character '" + this.s.charAt(this.index) + "'; expected end of string", this.index);
        }
    }
}

