/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.stream.ds;

import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.xop.AbstractXOPDecodingFilterHandler;
import org.apache.axiom.om.impl.intf.TextContent;
import org.apache.axiom.om.impl.stream.xop.XOPHandler;
import org.apache.axiom.util.UIDGenerator;

final class PushOMDataSourceXOPHandler
extends AbstractXOPDecodingFilterHandler
implements XOPHandler {
    private final Map<String, Blob> blobs = new HashMap<String, Blob>();

    PushOMDataSourceXOPHandler(XmlHandler parent) {
        super(parent);
    }

    @Override
    public String prepareBlob(Blob blob) {
        String contentID = UIDGenerator.generateContentId();
        this.blobs.put(contentID, blob);
        return contentID;
    }

    @Override
    protected Object buildCharacterData(String contentID) throws StreamException {
        Blob blob = this.blobs.get(contentID);
        if (blob == null) {
            throw new StreamException("No Blob found for content ID " + contentID);
        }
        return new TextContent(contentID, blob, true);
    }
}

