/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.client.config;

import java.util.List;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.binding.SOAPBinding;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.feature.ClientConfigurator;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.spi.Binding;
import org.apache.axis2.jaxws.spi.BindingProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MTOMConfigurator
implements ClientConfigurator {
    private static Log log = LogFactory.getLog(MTOMConfigurator.class);

    @Override
    public void configure(MessageContext messageContext, BindingProvider provider) {
        Binding bnd = (Binding)provider.getBinding();
        MTOMFeature mtomFeature = (MTOMFeature)bnd.getFeature("http://www.w3.org/2004/08/soap/features/http-optimization");
        Message requestMsg = messageContext.getMessage();
        requestMsg.setMTOMEnabled(false);
        if (mtomFeature == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"mtomFeatureErr"));
        }
        if (mtomFeature.isEnabled()) {
            int threshold = mtomFeature.getThreshold();
            List<String> attachmentIDs = requestMsg.getAttachmentIDs();
            requestMsg.setMTOMEnabled(true);
            if (threshold <= 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Enabling MTOM with no threshold.");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("MTOM Threshold Value =" + threshold));
                }
                messageContext.setProperty("mtomThreshold", new Integer(threshold));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"The MTOMFeature was found, but not enabled.");
        }
    }

    @Override
    public boolean supports(Binding binding) {
        return binding instanceof SOAPBinding;
    }
}

