/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.partition.range;

import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITupleMultiPartitionComputer;
import org.apache.hyracks.api.dataflow.value.ITupleMultiPartitionComputerFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.dataflow.common.data.partition.range.AbstractFieldRangePartitionComputerFactory;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMapSupplier;

public final class FieldRangeIntersectPartitionComputerFactory
extends AbstractFieldRangePartitionComputerFactory
implements ITupleMultiPartitionComputerFactory {
    private static final long serialVersionUID = 1L;
    private final int[] startFields;
    private final int[] endFields;

    public FieldRangeIntersectPartitionComputerFactory(int[] startFields, int[] endFields, IBinaryComparatorFactory[] comparatorFactories, RangeMapSupplier rangeMapSupplier, SourceLocation sourceLocation) {
        super(rangeMapSupplier, comparatorFactories, sourceLocation);
        this.startFields = startFields;
        this.endFields = endFields;
    }

    public ITupleMultiPartitionComputer createPartitioner(IHyracksTaskContext taskContext) {
        return new AbstractFieldRangePartitionComputerFactory.AbstractFieldRangeMultiPartitionComputer(taskContext){

            @Override
            protected int computeStartPartition(IFrameTupleAccessor accessor, int tIndex, int nParts) throws HyracksDataException {
                return this.rangeMapPartitionComputer.partition(accessor, tIndex, FieldRangeIntersectPartitionComputerFactory.this.startFields, nParts);
            }

            @Override
            protected int computeEndPartition(IFrameTupleAccessor accessor, int tIndex, int nParts) throws HyracksDataException {
                return this.rangeMapPartitionComputer.exclusivePartition(accessor, tIndex, FieldRangeIntersectPartitionComputerFactory.this.endFields, nParts);
            }
        };
    }
}

