/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.comparators;

import java.io.IOException;
import org.apache.asterix.dataflow.data.common.ILogicalBinaryComparator;
import org.apache.asterix.dataflow.data.common.ListAccessorUtil;
import org.apache.asterix.dataflow.data.common.TaggedValueReference;
import org.apache.asterix.dataflow.data.nontagged.comparators.ComparatorUtil;
import org.apache.asterix.dataflow.data.nontagged.comparators.LogicalScalarBinaryComparator;
import org.apache.asterix.dataflow.data.nontagged.serde.SerializerDeserializerUtil;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.pointables.nonvisitor.RecordField;
import org.apache.asterix.om.pointables.nonvisitor.SortedRecord;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.asterix.om.util.container.ObjectFactories;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public final class LogicalComplexBinaryComparator
implements ILogicalBinaryComparator {
    private final IAType leftType;
    private final IAType rightType;
    private final boolean isEquality;
    private final LogicalScalarBinaryComparator scalarComparator;
    private final ListObjectPool<TaggedValueReference, Void> taggedValuePool = new ListObjectPool<TaggedValueReference, Void>(ObjectFactories.VALUE_FACTORY);
    private final ListObjectPool<SortedRecord, ARecordType> recordPool = new ListObjectPool<SortedRecord, ARecordType>(ObjectFactories.RECORD_FACTORY);

    LogicalComplexBinaryComparator(IAType leftType, IAType rightType, boolean isEquality) {
        this.leftType = leftType;
        this.rightType = rightType;
        this.isEquality = isEquality;
        this.scalarComparator = LogicalScalarBinaryComparator.of(isEquality);
    }

    @Override
    public ILogicalBinaryComparator.Result compare(TaggedValueReference left, TaggedValueReference right) throws HyracksDataException {
        ATypeTag rightRuntimeTag;
        ATypeTag leftRuntimeTag = left.getTag();
        ILogicalBinaryComparator.Result comparisonResult = ComparatorUtil.returnMissingOrNullOrMismatch(leftRuntimeTag, rightRuntimeTag = right.getTag());
        if (comparisonResult != null) {
            return comparisonResult;
        }
        if (!leftRuntimeTag.isDerivedType() || !rightRuntimeTag.isDerivedType()) {
            throw new IllegalStateException("Input data is not complex type");
        }
        return this.compareComplex(this.leftType, leftRuntimeTag, left, this.rightType, rightRuntimeTag, right);
    }

    @Override
    public ILogicalBinaryComparator.Result compare(TaggedValueReference left, IAObject rightConstant) {
        ATypeTag rightTag;
        ATypeTag leftTag = left.getTag();
        ILogicalBinaryComparator.Result comparisonResult = ComparatorUtil.returnMissingOrNullOrMismatch(leftTag, rightTag = rightConstant.getType().getTypeTag());
        if (comparisonResult != null) {
            return comparisonResult;
        }
        return ILogicalBinaryComparator.Result.NULL;
    }

    @Override
    public ILogicalBinaryComparator.Result compare(IAObject leftConstant, TaggedValueReference right) {
        ILogicalBinaryComparator.Result result = this.compare(right, leftConstant);
        switch (result) {
            case LT: {
                return ILogicalBinaryComparator.Result.GT;
            }
            case GT: {
                return ILogicalBinaryComparator.Result.LT;
            }
        }
        return result;
    }

    @Override
    public ILogicalBinaryComparator.Result compare(IAObject leftConstant, IAObject rightConstant) {
        ATypeTag rightTag;
        ATypeTag leftTag = leftConstant.getType().getTypeTag();
        ILogicalBinaryComparator.Result comparisonResult = ComparatorUtil.returnMissingOrNullOrMismatch(leftTag, rightTag = rightConstant.getType().getTypeTag());
        if (comparisonResult != null) {
            return comparisonResult;
        }
        return ILogicalBinaryComparator.Result.NULL;
    }

    private ILogicalBinaryComparator.Result compareComplex(IAType leftType, ATypeTag leftRuntimeTag, TaggedValueReference left, IAType rightType, ATypeTag rightRuntimeTag, TaggedValueReference right) throws HyracksDataException {
        if (leftRuntimeTag != rightRuntimeTag) {
            return ILogicalBinaryComparator.Result.INCOMPARABLE;
        }
        IAType leftCompileType = TypeComputeUtils.getActualTypeOrOpen(leftType, leftRuntimeTag);
        IAType rightCompileType = TypeComputeUtils.getActualTypeOrOpen(rightType, rightRuntimeTag);
        switch (leftRuntimeTag) {
            case MULTISET: {
                return this.compareMultisets(leftCompileType, leftRuntimeTag, left, rightCompileType, rightRuntimeTag, right);
            }
            case ARRAY: {
                return this.compareArrays(leftCompileType, left, rightCompileType, right);
            }
            case OBJECT: {
                return this.compareRecords(leftCompileType, left, rightCompileType, right);
            }
        }
        return ILogicalBinaryComparator.Result.NULL;
    }

    private ILogicalBinaryComparator.Result compareArrays(IAType leftType, TaggedValueReference leftArray, IAType rightType, TaggedValueReference rightArray) throws HyracksDataException {
        int leftNumItems = SerializerDeserializerUtil.getNumberOfItemsNonTagged(leftArray);
        int rightNumItems = SerializerDeserializerUtil.getNumberOfItemsNonTagged(rightArray);
        IAType leftItemCompileType = ((AbstractCollectionType)leftType).getItemType();
        IAType rightItemCompileType = ((AbstractCollectionType)rightType).getItemType();
        ATypeTag leftArrayItemTag = leftItemCompileType.getTypeTag();
        ATypeTag rightArrayItemTag = rightItemCompileType.getTypeTag();
        boolean leftItemHasTag = leftArrayItemTag == ATypeTag.ANY;
        boolean rightItemHasTag = rightArrayItemTag == ATypeTag.ANY;
        TaggedValueReference leftItem = this.taggedValuePool.allocate(null);
        TaggedValueReference rightItem = this.taggedValuePool.allocate(null);
        ILogicalBinaryComparator.Result determiningResult = null;
        try {
            for (int i = 0; i < leftNumItems && i < rightNumItems; ++i) {
                ListAccessorUtil.getItemFromList(leftArray, i, leftItem, leftArrayItemTag, leftItemHasTag);
                ListAccessorUtil.getItemFromList(rightArray, i, rightItem, rightArrayItemTag, rightItemHasTag);
                ATypeTag leftItemRuntimeTag = leftItem.getTag();
                ATypeTag rightItemRuntimeTag = rightItem.getTag();
                ILogicalBinaryComparator.Result tempResult = leftItemRuntimeTag.isDerivedType() && rightItemRuntimeTag.isDerivedType() ? this.compareComplex(leftItemCompileType, leftItemRuntimeTag, leftItem, rightItemCompileType, rightItemRuntimeTag, rightItem) : this.scalarComparator.compare(leftItem, rightItem);
                if (tempResult == ILogicalBinaryComparator.Result.INCOMPARABLE || tempResult == ILogicalBinaryComparator.Result.MISSING || tempResult == ILogicalBinaryComparator.Result.NULL) {
                    ILogicalBinaryComparator.Result result = ILogicalBinaryComparator.Result.INCOMPARABLE;
                    return result;
                }
                if (determiningResult != null || tempResult == ILogicalBinaryComparator.Result.EQ) continue;
                determiningResult = tempResult;
            }
            if (determiningResult != null) {
                ILogicalBinaryComparator.Result i = determiningResult;
                return i;
            }
            ILogicalBinaryComparator.Result i = ILogicalBinaryComparator.asResult(Integer.compare(leftNumItems, rightNumItems));
            return i;
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        finally {
            this.taggedValuePool.free(rightItem);
            this.taggedValuePool.free(leftItem);
        }
    }

    private ILogicalBinaryComparator.Result compareMultisets(IAType leftType, ATypeTag leftListTag, TaggedValueReference left, IAType rightType, ATypeTag rightListTag, TaggedValueReference right) throws HyracksDataException {
        if (!this.isEquality) {
            return ILogicalBinaryComparator.Result.INCOMPARABLE;
        }
        return this.compareArrays(leftType, left, rightType, right);
    }

    private ILogicalBinaryComparator.Result compareRecords(IAType leftType, TaggedValueReference left, IAType rightType, TaggedValueReference right) throws HyracksDataException {
        if (!this.isEquality) {
            return ILogicalBinaryComparator.Result.INCOMPARABLE;
        }
        ARecordType leftRecordType = (ARecordType)TypeComputeUtils.getActualTypeOrOpen(leftType, ATypeTag.OBJECT);
        ARecordType rightRecordType = (ARecordType)TypeComputeUtils.getActualTypeOrOpen(rightType, ATypeTag.OBJECT);
        SortedRecord leftRecord = this.recordPool.allocate(leftRecordType);
        SortedRecord rightRecord = this.recordPool.allocate(rightRecordType);
        TaggedValueReference leftFieldValue = this.taggedValuePool.allocate(null);
        TaggedValueReference rightFieldValue = this.taggedValuePool.allocate(null);
        try {
            ILogicalBinaryComparator.Result result;
            leftRecord.resetNonTagged(left.getByteArray(), left.getStartOffset());
            rightRecord.resetNonTagged(right.getByteArray(), right.getStartOffset());
            boolean notEqual = false;
            RecordField leftField = null;
            RecordField rightField = null;
            int previousNamesComparisonResult = 0;
            while (!leftRecord.isEmpty() && !rightRecord.isEmpty()) {
                if (previousNamesComparisonResult == 0) {
                    leftField = leftRecord.poll();
                    rightField = rightRecord.poll();
                } else if (previousNamesComparisonResult > 0) {
                    rightField = rightRecord.poll();
                } else {
                    leftField = leftRecord.poll();
                }
                previousNamesComparisonResult = RecordField.FIELD_NAME_COMP.compare(leftField, rightField);
                if (previousNamesComparisonResult == 0) {
                    ILogicalBinaryComparator.Result tempCompResult;
                    leftRecord.getFieldValue(leftField, leftFieldValue);
                    rightRecord.getFieldValue(rightField, rightFieldValue);
                    ATypeTag leftFTag = leftFieldValue.getTag();
                    ATypeTag rightFTag = rightFieldValue.getTag();
                    if (leftFTag == ATypeTag.NULL || rightFTag == ATypeTag.NULL) {
                        tempCompResult = ILogicalBinaryComparator.Result.NULL;
                    } else if (leftFTag.isDerivedType() && rightFTag.isDerivedType()) {
                        IAType leftFieldType = RecordUtil.getType(leftRecordType, leftField.getIndex(), leftFTag);
                        IAType rightFieldType = RecordUtil.getType(rightRecordType, rightField.getIndex(), rightFTag);
                        tempCompResult = this.compareComplex(leftFieldType, leftFTag, leftFieldValue, rightFieldType, rightFTag, rightFieldValue);
                    } else {
                        tempCompResult = this.scalarComparator.compare(leftFieldValue, rightFieldValue);
                    }
                    if (tempCompResult == ILogicalBinaryComparator.Result.INCOMPARABLE || tempCompResult == ILogicalBinaryComparator.Result.MISSING || tempCompResult == ILogicalBinaryComparator.Result.NULL) {
                        ILogicalBinaryComparator.Result result2 = ILogicalBinaryComparator.Result.INCOMPARABLE;
                        return result2;
                    }
                    if (tempCompResult == ILogicalBinaryComparator.Result.EQ) continue;
                    notEqual = true;
                    continue;
                }
                notEqual = true;
            }
            if (notEqual || leftRecord.size() != rightRecord.size()) {
                result = ILogicalBinaryComparator.Result.LT;
                return result;
            }
            result = ILogicalBinaryComparator.Result.EQ;
            return result;
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        finally {
            this.recordPool.free(rightRecord);
            this.recordPool.free(leftRecord);
            this.taggedValuePool.free(rightFieldValue);
            this.taggedValuePool.free(leftFieldValue);
        }
    }
}

