/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.http.api.IServletRequest;

public class BaseRequest
implements IServletRequest {
    private static final List<String> NO_PARAM = Collections.singletonList(null);
    protected final FullHttpRequest request;
    protected final Map<? extends CharSequence, List<String>> parameters;
    protected final InetSocketAddress remoteAddress;
    protected final HttpScheme scheme;
    protected final InetSocketAddress localAddress;

    public static IServletRequest create(ChannelHandlerContext ctx, FullHttpRequest request, HttpScheme scheme, boolean ignoreQueryParameters) {
        Map param = ignoreQueryParameters ? Collections.emptyMap() : new QueryStringDecoder(request.uri()).parameters();
        InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        InetSocketAddress localAddress = (InetSocketAddress)ctx.channel().localAddress();
        return new BaseRequest(request, localAddress, remoteAddress, param, scheme);
    }

    protected BaseRequest(FullHttpRequest request, InetSocketAddress localAddress, InetSocketAddress remoteAddress, Map<? extends CharSequence, List<String>> parameters, HttpScheme scheme) {
        this.request = request;
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.parameters = parameters;
        this.scheme = scheme;
    }

    @Override
    public FullHttpRequest getHttpRequest() {
        return this.request;
    }

    @Override
    public String getParameter(CharSequence name) {
        return this.parameters.getOrDefault(name, NO_PARAM).get(0);
    }

    @Override
    public List<String> getParameterValues(CharSequence name) {
        return Collections.unmodifiableList(this.parameters.getOrDefault(name, Collections.emptyList()));
    }

    @Override
    public Set<String> getParameterNames() {
        HashSet<String> names = new HashSet<String>();
        this.parameters.keySet().forEach(name -> names.add(name.toString()));
        return names;
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        this.parameters.forEach((name, values) -> paramMap.put(name.toString(), (String)values.get(0)));
        return paramMap;
    }

    @Override
    public Map<String, List<String>> getParametersValues() {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        this.parameters.forEach((name, values) -> params.put(name.toString(), new ArrayList(values)));
        return params;
    }

    @Override
    public String getHeader(CharSequence name) {
        return this.request.headers().get(name);
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public HttpScheme getScheme() {
        return this.scheme;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }
}

