/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.row.generator;

import com.teradata.tpcds.Nulls;
import com.teradata.tpcds.Session;
import com.teradata.tpcds.Table;
import com.teradata.tpcds.distribution.DemographicsDistributions;
import com.teradata.tpcds.generator.IncomeBandGeneratorColumn;
import com.teradata.tpcds.row.IncomeBandRow;
import com.teradata.tpcds.row.generator.AbstractRowGenerator;
import com.teradata.tpcds.row.generator.RowGenerator;
import com.teradata.tpcds.row.generator.RowGeneratorResult;

public class IncomeBandRowGenerator
extends AbstractRowGenerator {
    public IncomeBandRowGenerator() {
        super(Table.INCOME_BAND);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        long nullBitMap = Nulls.createNullBitMap(Table.INCOME_BAND, this.getRandomNumberStream(IncomeBandGeneratorColumn.IB_NULLS));
        int ibIncomeBandId = (int)rowNumber;
        int ibLowerBound = DemographicsDistributions.getIncomeBandLowerBoundAtIndex((int)rowNumber - 1);
        int ibUpperBound = DemographicsDistributions.getIncomeBandUpperBoundAtIndex((int)rowNumber - 1);
        return new RowGeneratorResult(new IncomeBandRow(nullBitMap, ibIncomeBandId, ibLowerBound, ibUpperBound));
    }
}

