/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am.array;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.asterix.optimizer.rules.am.array.AbstractOperatorFromSubplanRewrite;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;

public class SelectFromSubplanRewrite
extends AbstractOperatorFromSubplanRewrite<SelectOperator> {
    private static final Set<FunctionIdentifier> optimizableFunctions = new HashSet<FunctionIdentifier>();
    private final Deque<SelectOperator> selectRootStack = new ArrayDeque<SelectOperator>();

    public static void addOptimizableFunction(FunctionIdentifier functionIdentifier) {
        optimizableFunctions.add(functionIdentifier);
    }

    @Override
    public SelectOperator createOperator(SelectOperator originalOperator, IOptimizationContext context) throws AlgebricksException {
        this.selectRootStack.push(originalOperator);
        this.reset(originalOperator.getSourceLocation(), context, optimizableFunctions);
        LogicalVariable originalSelectVar = this.getConditioningVariable((ILogicalExpression)originalOperator.getCondition().getValue());
        if (!((ILogicalOperator)((Mutable)originalOperator.getInputs().get(0)).getValue()).getOperatorTag().equals((Object)LogicalOperatorTag.SUBPLAN) || originalSelectVar == null) {
            return null;
        }
        SubplanOperator subplanOperator = (SubplanOperator)((Mutable)originalOperator.getInputs().get(0)).getValue();
        Pair<SelectOperator, UnnestOperator> traversalOutput = this.traverseSubplanBranch(subplanOperator, null, true);
        return traversalOutput == null ? null : (SelectOperator)traversalOutput.first;
    }

    @Override
    public SelectOperator restoreBeforeRewrite(List<Mutable<ILogicalOperator>> afterOperatorRefs, IOptimizationContext context) throws AlgebricksException {
        return this.selectRootStack.pop();
    }
}

