/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.data.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.hyracks.algebricks.data.IPrinter;
import org.apache.hyracks.algebricks.data.IPrinterFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.util.string.UTF8StringUtil;

public class UTF8StringPrinterFactory
implements IPrinterFactory {
    private static final long serialVersionUID = 1L;
    public static final UTF8StringPrinterFactory INSTANCE = new UTF8StringPrinterFactory();

    private UTF8StringPrinterFactory() {
    }

    @Override
    public IPrinter createPrinter() {
        return new IPrinter(){

            @Override
            public void print(byte[] b, int s, int l, PrintStream ps) throws HyracksDataException {
                try {
                    UTF8StringUtil.printUTF8StringWithQuotes((byte[])b, (int)s, (int)l, (OutputStream)ps);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }

            @Override
            public void init() throws HyracksDataException {
            }
        };
    }
}

