/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.freepage;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndexMetadataFrame;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IPageWriteFailureCallback;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class VirtualFreePageManager
implements IPageManager {
    private final AtomicInteger currentPageId = new AtomicInteger();
    private final IBufferCache bufferCache;
    private int fileId;

    public VirtualFreePageManager(IBufferCache bufferCache) {
        this.bufferCache = bufferCache;
        this.currentPageId.set(1);
    }

    public int takePage(ITreeIndexMetadataFrame metaFrame) throws HyracksDataException {
        return this.currentPageId.incrementAndGet();
    }

    public int takeBlock(ITreeIndexMetadataFrame metaFrame, int count) throws HyracksDataException {
        return this.currentPageId.getAndUpdate(operand -> operand + count) + 1;
    }

    public int getMaxPageId(ITreeIndexMetadataFrame metaFrame) throws HyracksDataException {
        return this.currentPageId.get();
    }

    public ITreeIndexMetadataFrame createMetadataFrame() {
        return null;
    }

    public void releasePage(ITreeIndexMetadataFrame metaFrame, int freePage) throws HyracksDataException {
        throw new HyracksDataException("Pages of an in memory index are released through the virtual buffer cache");
    }

    public void releaseBlock(ITreeIndexMetadataFrame metaFrame, int startingPage, int count) throws HyracksDataException {
        throw new HyracksDataException("Pages of an in memory index are released through the virtual buffer cache");
    }

    public int getMetadataPageId() {
        return 0;
    }

    public void open(int fileId) {
        this.fileId = fileId;
    }

    public void close(IPageWriteFailureCallback callback) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ITreeIndexFrameFactory interiorFrameFactory, ITreeIndexFrameFactory leafFrameFactory) throws HyracksDataException {
        this.currentPageId.set(1);
        ICachedPage page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)0), true);
        page.acquireWriteLatch();
        page.releaseWriteLatch(false);
        this.bufferCache.unpin(page);
        page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.currentPageId.get()), true);
        if (leafFrameFactory != null) {
            page.acquireWriteLatch();
            try {
                ITreeIndexFrame leafFrame = leafFrameFactory.createFrame();
                leafFrame.setPage(page);
                leafFrame.initBuffer((byte)0);
            }
            finally {
                page.releaseWriteLatch(true);
            }
        }
        this.bufferCache.unpin(page);
    }

    public int getRootPageId() throws HyracksDataException {
        return 1;
    }

    public void setRootPageId(int rootPage) throws HyracksDataException {
    }

    public int getBulkLoadLeaf() throws HyracksDataException {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(ITreeIndexFrame frame, int rootPage) throws HyracksDataException {
        ICachedPage rootNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)rootPage), false);
        rootNode.acquireReadLatch();
        try {
            frame.setPage(rootNode);
            boolean bl = frame.getLevel() == 0 && frame.getTupleCount() == 0;
            return bl;
        }
        finally {
            rootNode.releaseReadLatch();
            this.bufferCache.unpin(rootNode);
        }
    }
}

