/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.comm.channels;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.apache.hyracks.api.comm.IBufferAcceptor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.net.protocols.muxdemux.ChannelControlBlock;

public class NetworkOutputChannel
implements IFrameWriter {
    private final ChannelControlBlock ccb;
    private final int nBuffers;
    private final Deque<ByteBuffer> emptyStack;
    private boolean aborted;
    private int frameSize = 32768;
    private int allocateCounter = 0;

    public NetworkOutputChannel(ChannelControlBlock ccb, int nBuffers) {
        this.ccb = ccb;
        this.nBuffers = nBuffers;
        this.emptyStack = new ArrayDeque<ByteBuffer>(nBuffers);
        ccb.getWriteInterface().setEmptyBufferAcceptor((IBufferAcceptor)new WriteEmptyBufferAcceptor());
    }

    public void setFrameSize(int frameSize) {
        this.frameSize = frameSize;
    }

    public void open() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        while (buffer.hasRemaining()) {
            ByteBuffer destBuffer;
            NetworkOutputChannel networkOutputChannel = this;
            synchronized (networkOutputChannel) {
                while (true) {
                    if (this.aborted) {
                        throw new HyracksDataException("Connection has been aborted");
                    }
                    destBuffer = this.emptyStack.poll();
                    if (destBuffer == null && this.allocateCounter < this.nBuffers) {
                        destBuffer = ByteBuffer.allocateDirect(this.frameSize);
                        ++this.allocateCounter;
                    }
                    if (destBuffer != null) break;
                    try {
                        InetSocketAddress remoteAddress = this.ccb.getRemoteAddress();
                        String nameBefore = Thread.currentThread().getName();
                        try {
                            Thread.currentThread().setName(nameBefore + ":SendingTo(" + Objects.toString(remoteAddress) + ") over " + this.ccb);
                            this.wait();
                        }
                        finally {
                            Thread.currentThread().setName(nameBefore);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw HyracksDataException.create((Throwable)e);
                    }
                }
            }
            destBuffer.clear();
            if (destBuffer.capacity() < buffer.remaining()) {
                destBuffer.put(buffer.array(), buffer.position(), destBuffer.capacity());
                buffer.position(buffer.position() + destBuffer.capacity());
            } else {
                destBuffer.put(buffer);
            }
            destBuffer.flip();
            this.ccb.getWriteInterface().getFullBufferAcceptor().accept(destBuffer);
        }
    }

    public void fail() throws HyracksDataException {
        this.ccb.getWriteInterface().getFullBufferAcceptor().error(1);
    }

    public void close() throws HyracksDataException {
        this.ccb.getWriteInterface().getFullBufferAcceptor().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(int ecode) {
        this.ccb.getWriteInterface().getFullBufferAcceptor().error(ecode);
        NetworkOutputChannel networkOutputChannel = this;
        synchronized (networkOutputChannel) {
            this.aborted = true;
            this.notifyAll();
        }
    }

    public void flush() throws HyracksDataException {
    }

    private class WriteEmptyBufferAcceptor
    implements IBufferAcceptor {
        private WriteEmptyBufferAcceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accept(ByteBuffer buffer) {
            NetworkOutputChannel networkOutputChannel = NetworkOutputChannel.this;
            synchronized (networkOutputChannel) {
                NetworkOutputChannel.this.emptyStack.push(buffer);
                NetworkOutputChannel.this.notifyAll();
            }
        }
    }
}

