/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.fs.azurebfs.services.retryReasonCategories.ClientErrorRetryReason;
import org.apache.hadoop.fs.azurebfs.services.retryReasonCategories.ConnectionResetRetryReason;
import org.apache.hadoop.fs.azurebfs.services.retryReasonCategories.ConnectionTimeoutRetryReason;
import org.apache.hadoop.fs.azurebfs.services.retryReasonCategories.ReadTimeoutRetryReason;
import org.apache.hadoop.fs.azurebfs.services.retryReasonCategories.RetryReasonCategory;
import org.apache.hadoop.fs.azurebfs.services.retryReasonCategories.ServerErrorRetryReason;
import org.apache.hadoop.fs.azurebfs.services.retryReasonCategories.UnknownHostRetryReason;
import org.apache.hadoop.fs.azurebfs.services.retryReasonCategories.UnknownIOExceptionRetryReason;
import org.apache.hadoop.fs.azurebfs.services.retryReasonCategories.UnknownSocketExceptionRetryReason;

final class RetryReason {
    private static List<RetryReasonCategory> rankedReasonCategories = new LinkedList<RetryReasonCategory>(){
        {
            this.add(new ServerErrorRetryReason());
            this.add(new ClientErrorRetryReason());
            this.add(new UnknownIOExceptionRetryReason());
            this.add(new UnknownSocketExceptionRetryReason());
            this.add(new ConnectionTimeoutRetryReason());
            this.add(new ReadTimeoutRetryReason());
            this.add(new UnknownHostRetryReason());
            this.add(new ConnectionResetRetryReason());
        }
    };

    private RetryReason() {
    }

    static String getAbbreviation(Exception ex, Integer statusCode, String storageErrorMessage) {
        String result = null;
        for (RetryReasonCategory retryReasonCategory : rankedReasonCategories) {
            String abbreviation = retryReasonCategory.captureAndGetAbbreviation(ex, statusCode, storageErrorMessage);
            if (abbreviation == null) continue;
            result = abbreviation;
        }
        return result;
    }
}

