/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.meta;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.PipelineAssembler;
import org.apache.hyracks.algebricks.runtime.operators.meta.SubplanRuntimeFactory;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.ITimedWriter;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.profiling.IOperatorStats;
import org.apache.hyracks.api.job.profiling.NoOpOperatorStats;
import org.apache.hyracks.api.job.profiling.OperatorStats;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputIntrospectingOperatorNodePushable;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;

public class AlgebricksMetaOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 3L;
    private final AlgebricksPipeline pipeline;

    public AlgebricksMetaOperatorDescriptor(IOperatorDescriptorRegistry spec, int inputArity, int outputArity, IPushRuntimeFactory[] runtimeFactories, RecordDescriptor[] internalRecordDescriptors) {
        this(spec, inputArity, outputArity, runtimeFactories, internalRecordDescriptors, null, null);
    }

    public AlgebricksMetaOperatorDescriptor(IOperatorDescriptorRegistry spec, int inputArity, int outputArity, IPushRuntimeFactory[] runtimeFactories, RecordDescriptor[] internalRecordDescriptors, IPushRuntimeFactory[] outputRuntimeFactories, int[] outputPositions) {
        super(spec, inputArity, outputArity);
        if (outputArity == 1) {
            this.outRecDescs[0] = internalRecordDescriptors[internalRecordDescriptors.length - 1];
        }
        this.pipeline = new AlgebricksPipeline(runtimeFactories, internalRecordDescriptors, outputRuntimeFactories, outputPositions);
    }

    public AlgebricksPipeline getPipeline() {
        return this.pipeline;
    }

    public ObjectNode toJSON() {
        ObjectNode json = super.toJSON();
        json.put("micro-operators", Arrays.toString(this.pipeline.getRuntimeFactories()));
        return json;
    }

    public String toString() {
        return "AlgebricksMeta " + Arrays.toString(this.pipeline.getRuntimeFactories());
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) {
        if (this.inputArity == 0) {
            return new SourcePushRuntime(ctx);
        }
        return this.createOneInputOneOutputPushRuntime(ctx, recordDescProvider);
    }

    private static String makeStatName(String base, String name, int pos, int input, int subPlan, int subPos) {
        StringBuilder sb = new StringBuilder();
        sb.append(base);
        sb.append(".");
        sb.append(pos);
        if (subPlan >= 0) {
            sb.append(".");
            sb.append(subPlan);
            sb.append(".");
            sb.append(subPos);
            sb.append(" - Subplan ");
        } else {
            sb.append(" - MicroOp ");
        }
        sb.append(name);
        if (input >= 0) {
            sb.append(" input [");
            sb.append(input);
            sb.append("] ");
        }
        return sb.toString();
    }

    private static String makeId(String base, int id, int subPlan, int subPos) {
        return base + "." + id + (String)(subPlan >= 0 ? "." + subPlan : "") + (String)(subPos >= 0 ? "." + subPos : "");
    }

    private static IOperatorStats makeStatForRuntimeFact(IPushRuntimeFactory factory, String base, String baseId, int pos, int subPlan, int subPos) {
        return new OperatorStats(AlgebricksMetaOperatorDescriptor.makeStatName(base, factory.toString(), pos, -1, subPlan, subPos), AlgebricksMetaOperatorDescriptor.makeId(baseId, pos, subPlan, subPos));
    }

    public static Map<IPushRuntimeFactory, IOperatorStats> makeMicroOpStats(AlgebricksPipeline pipe, IOperatorStats outerStats) {
        HashMap<IPushRuntimeFactory, IOperatorStats> microOpStats = new HashMap<IPushRuntimeFactory, IOperatorStats>();
        String baseName = outerStats.getName().split(" - ")[0];
        String baseId = outerStats.getOperatorId();
        ArrayList<SubplanRuntimeFactory> subplans = new ArrayList<SubplanRuntimeFactory>();
        for (int i = 0; i < pipe.getRuntimeFactories().length; ++i) {
            IPushRuntimeFactory fact = pipe.getRuntimeFactories()[i];
            if (fact instanceof SubplanRuntimeFactory) {
                SubplanRuntimeFactory subplanFact = (SubplanRuntimeFactory)fact;
                subplans.add(subplanFact);
                List<AlgebricksPipeline> pipelines = subplanFact.getPipelines();
                for (AlgebricksPipeline p : pipelines) {
                    IPushRuntimeFactory[] subplanFactories = p.getRuntimeFactories();
                    for (int j = subplanFactories.length - 1; j > 0; --j) {
                        microOpStats.put(subplanFactories[j], AlgebricksMetaOperatorDescriptor.makeStatForRuntimeFact(subplanFactories[j], baseName, baseId, i, pipelines.indexOf(p), j));
                    }
                }
            }
            microOpStats.put(fact, AlgebricksMetaOperatorDescriptor.makeStatForRuntimeFact(fact, baseName, baseId, i, -1, -1));
        }
        for (SubplanRuntimeFactory sub : subplans) {
            sub.setStats(microOpStats);
        }
        return microOpStats;
    }

    private IOperatorNodePushable createOneInputOneOutputPushRuntime(final IHyracksTaskContext ctx, final IRecordDescriptorProvider recordDescProvider) {
        return new AbstractUnaryInputUnaryOutputIntrospectingOperatorNodePushable(){
            private IFrameWriter startOfPipeline;
            private boolean opened = false;
            private IOperatorStats parentStats = NoOpOperatorStats.INSTANCE;
            private Map<IPushRuntimeFactory, IOperatorStats> microOpStats = new HashMap<IPushRuntimeFactory, IOperatorStats>();

            public void open() throws HyracksDataException {
                if (this.startOfPipeline == null) {
                    RecordDescriptor pipelineOutputRecordDescriptor = AlgebricksMetaOperatorDescriptor.this.outputArity > 0 ? AlgebricksMetaOperatorDescriptor.this.outRecDescs[0] : null;
                    RecordDescriptor pipelineInputRecordDescriptor = recordDescProvider.getInputRecordDescriptor(AlgebricksMetaOperatorDescriptor.this.getActivityId(), 0);
                    PipelineAssembler pa = new PipelineAssembler(AlgebricksMetaOperatorDescriptor.this.pipeline, AlgebricksMetaOperatorDescriptor.this.inputArity, AlgebricksMetaOperatorDescriptor.this.outputArity, pipelineInputRecordDescriptor, pipelineOutputRecordDescriptor);
                    this.startOfPipeline = pa.assemblePipeline(this.writer, ctx, this.microOpStats);
                }
                this.opened = true;
                this.startOfPipeline.open();
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.startOfPipeline.nextFrame(buffer);
            }

            public void close() throws HyracksDataException {
                if (this.opened) {
                    this.startOfPipeline.close();
                }
            }

            public void fail() throws HyracksDataException {
                if (this.opened) {
                    this.startOfPipeline.fail();
                }
            }

            public void flush() throws HyracksDataException {
                this.startOfPipeline.flush();
            }

            public void deinitialize() throws HyracksDataException {
                super.deinitialize();
            }

            public String toString() {
                return AlgebricksMetaOperatorDescriptor.this.toString();
            }

            public void addStats(IOperatorStats stats) throws HyracksDataException {
                this.microOpStats = AlgebricksMetaOperatorDescriptor.makeMicroOpStats(AlgebricksMetaOperatorDescriptor.this.pipeline, stats);
                for (IOperatorStats stat : this.microOpStats.values()) {
                    ctx.getStatsCollector().add(stat);
                }
            }

            public void setUpstreamStats(IOperatorStats stats) {
                this.parentStats = stats;
            }

            public long getTotalTime() {
                return this.startOfPipeline instanceof ITimedWriter ? ((ITimedWriter)this.startOfPipeline).getTotalTime() : 0L;
            }

            public IOperatorStats getStats() {
                IPushRuntimeFactory[] facts = AlgebricksMetaOperatorDescriptor.this.pipeline.getRuntimeFactories();
                return this.microOpStats.getOrDefault(facts[facts.length - 1], (IOperatorStats)NoOpOperatorStats.INSTANCE);
            }
        };
    }

    private class SourcePushRuntime
    extends AbstractUnaryOutputSourceOperatorNodePushable {
        private final IHyracksTaskContext ctx;

        SourcePushRuntime(IHyracksTaskContext ctx) {
            this.ctx = ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initialize() throws HyracksDataException {
            RecordDescriptor pipelineOutputRecordDescriptor = AlgebricksMetaOperatorDescriptor.this.outputArity > 0 ? AlgebricksMetaOperatorDescriptor.this.outRecDescs[0] : null;
            PipelineAssembler pa = new PipelineAssembler(AlgebricksMetaOperatorDescriptor.this.pipeline, AlgebricksMetaOperatorDescriptor.this.inputArity, AlgebricksMetaOperatorDescriptor.this.outputArity, null, pipelineOutputRecordDescriptor);
            IFrameWriter startOfPipeline = pa.assemblePipeline(this.writer, this.ctx, new HashMap<IPushRuntimeFactory, IOperatorStats>());
            HyracksDataException exception = null;
            try {
                startOfPipeline.open();
            }
            catch (Exception e) {
                startOfPipeline.fail();
                exception = HyracksDataException.create((Throwable)e);
            }
            finally {
                try {
                    startOfPipeline.close();
                }
                catch (Exception e) {
                    if (exception == null) {
                        exception = HyracksDataException.create((Throwable)e);
                    }
                    exception.addSuppressed((Throwable)e);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }

        public String getDisplayName() {
            return "Empty Tuple Source";
        }
    }
}

