/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.test;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.test.TestEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.URISupport;

public class TestComponent
extends UriEndpointComponent {
    public TestComponent() {
        super(TestEndpoint.class);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Long timeout = this.getAndRemoveParameter(parameters, "timeout", Long.class);
        TestEndpoint answer = new TestEndpoint(uri, this);
        if (timeout != null) {
            answer.setTimeout(timeout);
        }
        this.setProperties(answer, parameters);
        String endpointUri = URISupport.appendParametersToURI(remaining, parameters);
        Endpoint endpoint = CamelContextHelper.getMandatoryEndpoint(this.getCamelContext(), endpointUri);
        answer.setExpectedMessageEndpoint(endpoint);
        return answer;
    }
}

