/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.unicodeconvert;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

class HtmlPane
extends JScrollPane
implements HyperlinkListener {
    private JEditorPane html;
    private JTextField statusBar;
    private final ClassLoader cLoader = this.getClass().getClassLoader();

    public HtmlPane(String string) {
        this.setPreferredSize(new Dimension(600, 300));
        try {
            URL uRL = this.cLoader.getResource(string);
            this.html = new JEditorPane(uRL);
            this.html.setEditable(false);
            this.html.setMargin(new Insets(5, 10, 5, 5));
            this.html.addHyperlinkListener(this);
            JViewport jViewport = this.getViewport();
            jViewport.add(this.html);
            this.statusBar = new JTextField();
            this.statusBar.setEditable(false);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Malformed URL: " + malformedURLException);
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.statusBar.setText(hyperlinkEvent.getURL().toString());
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.statusBar.setText(null);
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(hyperlinkEvent.getURL());
        }
    }

    protected void linkActivated(URL uRL) {
        try {
            Desktop.getDesktop().browse(uRL.toURI());
        }
        catch (Exception exception) {
            System.err.println("Error message: " + exception.getMessage());
            Cursor cursor = this.html.getCursor();
            Cursor cursor2 = Cursor.getPredefinedCursor(3);
            this.html.setCursor(cursor2);
            SwingUtilities.invokeLater(new PageLoader(uRL, cursor));
        }
    }

    public JTextField getStatusBar() {
        return this.statusBar;
    }

    class PageLoader
    implements Runnable {
        URL url;
        Cursor cursor;

        PageLoader(URL uRL, Cursor cursor) {
            this.url = uRL;
            this.cursor = cursor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.url == null) {
                HtmlPane.this.html.setCursor(this.cursor);
                Container container = HtmlPane.this.html.getParent();
                container.repaint();
            } else {
                Document document = HtmlPane.this.html.getDocument();
                try {
                    HtmlPane.this.html.setPage(this.url);
                }
                catch (IOException iOException) {
                    HtmlPane.this.html.setDocument(document);
                    HtmlPane.this.getToolkit().beep();
                }
                finally {
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }
}

