/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.mvc.annotation;

import java.lang.reflect.Method;
import java.util.HashSet;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.generic.GenericBeanFactoryAccessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.handler.AbstractMapBasedHandlerMapping;
import org.springframework.web.portlet.mvc.annotation.PortletAnnotationMappingUtils;

public class DefaultAnnotationHandlerMapping
extends AbstractMapBasedHandlerMapping {
    public void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        this.detectHandlers();
    }

    protected void detectHandlers() throws BeansException {
        String[] beanNames;
        ApplicationContext context = this.getApplicationContext();
        for (String beanName : beanNames = context.getBeanNamesForType(Object.class)) {
            Class handlerType = context.getType(beanName);
            Object bf = context instanceof ConfigurableApplicationContext ? ((ConfigurableApplicationContext)context).getBeanFactory() : context;
            GenericBeanFactoryAccessor bfa = new GenericBeanFactoryAccessor((ListableBeanFactory)bf);
            RequestMapping mapping = (RequestMapping)bfa.findAnnotationOnBean(beanName, RequestMapping.class);
            if (mapping != null) {
                String[] modeKeys = mapping.value();
                String[] params = mapping.params();
                boolean registerHandlerType = true;
                if (modeKeys.length == 0 || params.length == 0) {
                    boolean bl = registerHandlerType = !this.detectHandlerMethods(handlerType, beanName, mapping);
                }
                if (!registerHandlerType) continue;
                ParameterMappingPredicate predicate = new ParameterMappingPredicate(params);
                for (String modeKey : modeKeys) {
                    this.registerHandler(new PortletMode(modeKey), beanName, predicate);
                }
                continue;
            }
            if (AnnotationUtils.findAnnotation((Class)handlerType, Controller.class) == null) continue;
            this.detectHandlerMethods(handlerType, beanName, mapping);
        }
    }

    protected boolean detectHandlerMethods(Class handlerType, final String beanName, final RequestMapping typeMapping) {
        final HashSet handlersRegistered = new HashSet(1);
        ReflectionUtils.doWithMethods((Class)handlerType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                RequestMapping mapping = method.getAnnotation(RequestMapping.class);
                if (mapping != null) {
                    String[] modeKeys = mapping.value();
                    if (modeKeys.length == 0) {
                        if (typeMapping != null) {
                            modeKeys = typeMapping.value();
                        } else {
                            throw new IllegalStateException("No portlet mode mappings specified - neither at type nor method level");
                        }
                    }
                    String[] params = mapping.params();
                    if (typeMapping != null) {
                        PortletAnnotationMappingUtils.validateModeMapping(modeKeys, typeMapping.value());
                        params = StringUtils.mergeStringArrays((String[])typeMapping.params(), (String[])params);
                    }
                    ParameterMappingPredicate predicate = new ParameterMappingPredicate(params);
                    for (String modeKey : modeKeys) {
                        DefaultAnnotationHandlerMapping.this.registerHandler(new PortletMode(modeKey), beanName, predicate);
                        handlersRegistered.add(Boolean.TRUE);
                    }
                }
            }
        });
        return !handlersRegistered.isEmpty();
    }

    protected Object getLookupKey(PortletRequest request) throws Exception {
        return request.getPortletMode();
    }

    private static class ParameterMappingPredicate
    implements AbstractMapBasedHandlerMapping.PortletRequestMappingPredicate {
        private final String[] params;

        private ParameterMappingPredicate(String[] params) {
            this.params = params;
        }

        public boolean match(PortletRequest request) {
            return PortletAnnotationMappingUtils.checkParameters(this.params, request);
        }

        public int compareTo(Object other) {
            if (other instanceof AbstractMapBasedHandlerMapping.PortletRequestMappingPredicate) {
                return new Integer(((ParameterMappingPredicate)other).params.length).compareTo(this.params.length);
            }
            return 0;
        }

        public String toString() {
            return StringUtils.arrayToCommaDelimitedString((Object[])this.params);
        }
    }
}

