/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.springframework.web.portlet.context.PortletApplicationObjectSupport;
import org.springframework.web.portlet.handler.PortletSessionRequiredException;

public abstract class PortletContentGenerator
extends PortletApplicationObjectSupport {
    private boolean requireSession = false;
    private int cacheSeconds = -1;

    public final void setRequireSession(boolean requireSession) {
        this.requireSession = requireSession;
    }

    public final boolean isRequireSession() {
        return this.requireSession;
    }

    public final void setCacheSeconds(int seconds) {
        this.cacheSeconds = seconds;
    }

    public final int getCacheSeconds() {
        return this.cacheSeconds;
    }

    protected final void check(PortletRequest request, PortletResponse response) throws PortletException {
        if (this.requireSession && request.getPortletSession(false) == null) {
            throw new PortletSessionRequiredException("Pre-existing session required but none found");
        }
    }

    protected final void checkAndPrepare(RenderRequest request, RenderResponse response) throws PortletException {
        this.checkAndPrepare(request, response, this.cacheSeconds);
    }

    protected final void checkAndPrepare(RenderRequest request, RenderResponse response, int cacheSeconds) throws PortletException {
        this.check((PortletRequest)request, (PortletResponse)response);
        this.applyCacheSeconds(response, cacheSeconds);
    }

    protected final void preventCaching(RenderResponse response) {
        this.cacheForSeconds(response, 0);
    }

    protected final void cacheForSeconds(RenderResponse response, int seconds) {
        response.setProperty("portlet.expiration-cache", Integer.toString(seconds));
    }

    protected final void applyCacheSeconds(RenderResponse response, int seconds) {
        if (seconds > 0) {
            this.cacheForSeconds(response, seconds);
        } else if (seconds == 0) {
            this.preventCaching(response);
        }
    }
}

