/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.sessions;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.descriptors.VersionLockingPolicy;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.descriptors.ObjectBuilder;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.helper.linkedlist.LinkedNode;
import oracle.toplink.essentials.internal.identitymaps.CacheKey;
import oracle.toplink.essentials.internal.queryframework.ContainerPolicy;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.queryframework.DoesExistQuery;

public class MergeManager {
    protected AbstractSession session;
    protected IdentityHashtable objectDescriptors;
    protected IdentityHashtable objectsAlreadyMerged;
    protected IdentityHashtable mergedNewObjects;
    protected ArrayList acquiredLocks;
    protected CacheKey writeLockQueued;
    protected LinkedNode queueNode;
    protected int mergePolicy;
    protected static final int WORKING_COPY_INTO_ORIGINAL = 1;
    protected static final int ORIGINAL_INTO_WORKING_COPY = 2;
    protected static final int CLONE_INTO_WORKING_COPY = 3;
    protected static final int WORKING_COPY_INTO_REMOTE = 4;
    protected static final int REFRESH_REMOTE_OBJECT = 5;
    protected static final int CHANGES_INTO_DISTRIBUTED_CACHE = 6;
    protected static final int CLONE_WITH_REFS_INTO_WORKING_COPY = 7;
    protected static final int WORKING_COPY_INTO_BACKUP = 9;
    protected int cascadePolicy;
    public static final int NO_CASCADE = 1;
    public static final int CASCADE_PRIVATE_PARTS = 2;
    public static final int CASCADE_ALL_PARTS = 3;
    public static final int CASCADE_BY_MAPPING = 4;
    protected long systemTime = 0L;
    public static boolean LOCK_ON_MERGE = true;
    protected boolean forceCascade;

    public MergeManager(AbstractSession session) {
        this.session = session;
        this.mergedNewObjects = new IdentityHashtable();
        this.objectsAlreadyMerged = new IdentityHashtable();
        this.cascadePolicy = 3;
        this.mergePolicy = 1;
        this.objectDescriptors = new IdentityHashtable();
        this.acquiredLocks = new ArrayList();
    }

    protected IdentityHashtable buildIdentitySet(Object container, ContainerPolicy containerPolicy, boolean keyByTarget) {
        IdentityHashtable result = new IdentityHashtable(containerPolicy.sizeFor(container) + 1);
        Object iter = containerPolicy.iteratorFor(container);
        while (containerPolicy.hasNext(iter)) {
            Object element = containerPolicy.next(iter, this.getSession());
            if (keyByTarget) {
                result.put(this.getTargetVersionOfSourceObject(element), element);
                continue;
            }
            result.put(element, element);
        }
        return result;
    }

    public void cascadeAllParts() {
        this.setCascadePolicy(3);
    }

    public void cascadePrivateParts() {
        this.setCascadePolicy(2);
    }

    public void dontCascadeParts() {
        this.setCascadePolicy(1);
    }

    public ArrayList getAcquiredLocks() {
        return this.acquiredLocks;
    }

    public int getCascadePolicy() {
        return this.cascadePolicy;
    }

    protected int getMergePolicy() {
        return this.mergePolicy;
    }

    public IdentityHashtable getObjectDescriptors() {
        return this.objectDescriptors;
    }

    public IdentityHashtable getObjectsAlreadyMerged() {
        return this.objectsAlreadyMerged;
    }

    public Object getObjectToMerge(Object sourceValue) {
        if (this.shouldMergeOriginalIntoWorkingCopy()) {
            return this.getTargetVersionOfSourceObject(sourceValue);
        }
        return sourceValue;
    }

    public LinkedNode getQueueNode() {
        return this.queueNode;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public long getSystemTime() {
        if (this.systemTime == 0L) {
            this.systemTime = System.currentTimeMillis();
        }
        return this.systemTime;
    }

    public Object getTargetVersionOfSourceObject(Object source) {
        if (this.shouldMergeWorkingCopyIntoOriginal() || this.shouldMergeWorkingCopyIntoRemote()) {
            return ((UnitOfWorkImpl)this.getSession()).getOriginalVersionOfObject(source);
        }
        if (this.shouldMergeCloneIntoWorkingCopy() || this.shouldMergeOriginalIntoWorkingCopy() || this.shouldMergeCloneWithReferencesIntoWorkingCopy()) {
            return this.registerObjectForMergeCloneIntoWorkingCopy(source);
        }
        if (this.shouldRefreshRemoteObject()) {
            ClassDescriptor descriptor = this.getSession().getDescriptor(source);
            Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(source, this.getSession());
            return this.getSession().getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, source.getClass(), descriptor, null);
        }
        throw ValidationException.invalidMergePolicy();
    }

    public CacheKey getWriteLockQueued() {
        return this.writeLockQueued;
    }

    public Object mergeChanges(Object object, ObjectChangeSet objectChangeSet) throws ValidationException {
        Object mergedObject;
        if (object == null) {
            return object;
        }
        if (this.getSession().isClassReadOnly(object.getClass())) {
            return object;
        }
        if (this.getObjectsAlreadyMerged().containsKey(object)) {
            return object;
        }
        this.getObjectsAlreadyMerged().put(object, object);
        if (this.shouldMergeWorkingCopyIntoOriginal()) {
            mergedObject = this.mergeChangesOfWorkingCopyIntoOriginal(object, objectChangeSet);
        } else if (this.shouldMergeCloneIntoWorkingCopy() || this.shouldMergeCloneWithReferencesIntoWorkingCopy()) {
            mergedObject = this.mergeChangesOfCloneIntoWorkingCopy(object);
        } else if (this.shouldMergeOriginalIntoWorkingCopy()) {
            mergedObject = this.mergeChangesOfOriginalIntoWorkingCopy(object);
        } else {
            throw ValidationException.invalidMergePolicy();
        }
        return mergedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeChangesFromChangeSet(UnitOfWorkChangeSet uowChangeSet) {
        this.getSession().startOperationProfile("distributed merge");
        this.getSession().getIdentityMapAccessorInstance().acquireWriteLock();
        this.getSession().log(2, "propagation", "received_updates_from_remote_server");
        this.getSession().getEventManager().preDistributedMergeUnitOfWorkChangeSet(uowChangeSet);
        try {
            this.getSession().getIdentityMapAccessorInstance().getWriteLockManager().acquireRequiredLocks(this, uowChangeSet);
            Enumeration objectChangeEnum = uowChangeSet.getAllChangeSets().keys();
            while (objectChangeEnum.hasMoreElements()) {
                ObjectChangeSet objectChangeSet = (ObjectChangeSet)objectChangeEnum.nextElement();
                Object object = objectChangeSet.getTargetVersionOfSourceObject(this.getSession(), false);
                Object mergedObject = this.mergeChanges(object, objectChangeSet);
                if (mergedObject == null && objectChangeSet.isNew()) {
                    mergedObject = this.mergeNewObjectIntoCache(objectChangeSet);
                }
                if (mergedObject == null) {
                    this.getSession().incrementProfile("ChangesNotProcessed");
                    continue;
                }
                this.getSession().incrementProfile("ChangesProcessed");
            }
            Enumeration deletedObjects = uowChangeSet.getDeletedObjects().elements();
            while (deletedObjects.hasMoreElements()) {
                ObjectChangeSet changeSet = (ObjectChangeSet)deletedObjects.nextElement();
                changeSet.removeFromIdentityMap(this.getSession());
                this.getSession().incrementProfile("deleted object");
            }
        }
        catch (RuntimeException exception) {
            this.getSession().handleException(exception);
        }
        finally {
            this.getSession().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this);
            this.getSession().getIdentityMapAccessorInstance().releaseWriteLock();
            this.getSession().getEventManager().postDistributedMergeUnitOfWorkChangeSet(uowChangeSet);
            this.getSession().endOperationProfile("distributed merge");
        }
    }

    public boolean mergeChangesInCollection(Object source, Object target, Object backup, DatabaseMapping mapping) {
        ContainerPolicy containerPolicy = mapping.getContainerPolicy();
        IdentityHashtable backupSet = this.buildIdentitySet(backup, containerPolicy, false);
        IdentityHashtable sourceSet = null;
        IdentityHashtable targetToSources = null;
        if (this.shouldMergeWorkingCopyIntoOriginal()) {
            sourceSet = this.buildIdentitySet(source, containerPolicy, false);
        } else {
            targetToSources = this.buildIdentitySet(source, containerPolicy, true);
        }
        boolean changeOccured = false;
        if (backup == target) {
            backup = containerPolicy.cloneFor(backup);
        }
        Object backupIter = containerPolicy.iteratorFor(backup);
        while (containerPolicy.hasNext(backupIter)) {
            Object backupElement = containerPolicy.next(backupIter, this.getSession());
            if (this.shouldMergeWorkingCopyIntoOriginal()) {
                if (sourceSet.containsKey(backupElement)) continue;
                changeOccured = true;
                containerPolicy.removeFrom(null, this.getTargetVersionOfSourceObject(backupElement), target, this.getSession());
                if (!mapping.isPrivateOwned()) continue;
                this.registerRemovedNewObjectIfRequired(backupElement);
                continue;
            }
            if (targetToSources.containsKey(backupElement)) continue;
            changeOccured = true;
            containerPolicy.removeFrom(null, backupElement, target, this.getSession());
        }
        Object sourceIter = containerPolicy.iteratorFor(source);
        while (containerPolicy.hasNext(sourceIter)) {
            Object sourceElement = containerPolicy.next(sourceIter, this.getSession());
            mapping.cascadeMerge(sourceElement, this);
            if (this.shouldMergeWorkingCopyIntoOriginal()) {
                if (!backupSet.containsKey(sourceElement)) {
                    changeOccured = true;
                    containerPolicy.addInto(this.getTargetVersionOfSourceObject(sourceElement), target, this.getSession());
                    continue;
                }
                containerPolicy.validateElementAndRehashIfRequired(sourceElement, target, this.getSession(), this.getTargetVersionOfSourceObject(sourceElement));
                continue;
            }
            Object targetVersionOfSourceElement = this.getTargetVersionOfSourceObject(sourceElement);
            if (backupSet.containsKey(targetVersionOfSourceElement)) continue;
            changeOccured = true;
            containerPolicy.addInto(targetVersionOfSourceElement, target, this.getSession());
        }
        return changeOccured;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object mergeChangesOfCloneIntoWorkingCopy(Object rmiClone) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(rmiClone);
        Object registeredObject = this.registerObjectForMergeCloneIntoWorkingCopy(rmiClone);
        if (registeredObject == rmiClone && !this.shouldForceCascade()) {
            return rmiClone;
        }
        boolean changeTracked = false;
        try {
            Object currentValue;
            VersionLockingPolicy policy;
            ObjectBuilder builder = descriptor.getObjectBuilder();
            if (registeredObject != rmiClone && descriptor.usesVersionLocking() && !this.mergedNewObjects.containsKey(registeredObject) && (policy = (VersionLockingPolicy)descriptor.getOptimisticLockingPolicy()).isStoredInObject() && policy.isNewerVersion(currentValue = builder.extractValueFromObjectForField(registeredObject, policy.getWriteLockField(), this.session), rmiClone, this.session.keyFromObject(rmiClone), this.session)) {
                throw OptimisticLockException.objectChangedSinceLastMerge(rmiClone);
            }
            descriptor.getObjectChangePolicy().dissableEventProcessing(registeredObject);
            boolean cascadeOnly = false;
            if (registeredObject == rmiClone) {
                cascadeOnly = true;
            }
            builder.mergeIntoObject(registeredObject, false, rmiClone, this, cascadeOnly);
        }
        finally {
            descriptor.getObjectChangePolicy().enableEventProcessing(registeredObject);
        }
        return registeredObject;
    }

    protected Object mergeChangesOfOriginalIntoWorkingCopy(Object clone) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(clone);
        Object original = ((UnitOfWorkImpl)this.getSession()).getOriginalVersionOfObjectOrNull(clone);
        if (original == null) {
            return clone;
        }
        descriptor.getObjectBuilder().mergeIntoObject(clone, false, original, this);
        descriptor.getObjectChangePolicy().revertChanges(clone, descriptor, (UnitOfWorkImpl)this.getSession(), ((UnitOfWorkImpl)this.getSession()).getCloneMapping());
        Vector primaryKey = this.getSession().keyFromObject(clone);
        if (descriptor.usesOptimisticLocking()) {
            descriptor.getOptimisticLockingPolicy().mergeIntoParentCache((UnitOfWorkImpl)this.getSession(), primaryKey, clone);
        }
        CacheKey parentCacheKey = ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, clone.getClass(), descriptor);
        CacheKey uowCacheKey = this.getSession().getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, clone.getClass(), descriptor);
        if (parentCacheKey != null && uowCacheKey != null) {
            uowCacheKey.setReadTime(parentCacheKey.getReadTime());
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object mergeChangesOfWorkingCopyIntoOriginal(Object clone, ObjectChangeSet objectChangeSet) {
        UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.getSession();
        Object original = unitOfWork.getOriginalVersionOfObjectOrNull(clone);
        ClassDescriptor descriptor = unitOfWork.getDescriptor(clone.getClass());
        try {
            AbstractSession parent;
            if (original == null) {
                original = unitOfWork.buildOriginal(clone);
                if (objectChangeSet == null) {
                    descriptor.getObjectBuilder().mergeIntoObject(original, true, clone, this);
                } else if (!objectChangeSet.isNew()) {
                    parent = unitOfWork.getParent();
                    original = parent.getIdentityMapAccessorInstance().getWriteLockManager().appendLock(objectChangeSet.getPrimaryKeys(), original, descriptor, this, parent);
                    descriptor.getObjectBuilder().mergeIntoObject(original, true, clone, this);
                } else {
                    descriptor.getObjectBuilder().mergeChangesIntoObject(original, objectChangeSet, clone, this);
                }
            } else if (objectChangeSet == null) {
                descriptor.getObjectBuilder().mergeIntoObject(original, false, clone, this);
            } else {
                if (!objectChangeSet.isNew() && objectChangeSet.shouldInvalidateObject(original, parent = unitOfWork.getParent())) {
                    parent.getIdentityMapAccessor().invalidateObject(original);
                    return clone;
                }
                descriptor.getObjectBuilder().mergeChangesIntoObject(original, objectChangeSet, clone, this);
            }
        }
        catch (QueryException exception) {
            if (unitOfWork.shouldPerformNoValidation() || descriptor.hasWrapperPolicy()) {
                if (exception.getErrorCode() != 6066 && exception.getErrorCode() != 6004 && exception.getErrorCode() != 6005) {
                    throw exception;
                }
                return clone;
            }
            throw exception;
        }
        if (!unitOfWork.isNestedUnitOfWork()) {
            Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(clone, unitOfWork);
            CacheKey cacheKey = unitOfWork.getParent().getIdentityMapAccessorInstance().acquireLock(primaryKey, original.getClass(), descriptor);
            try {
                if (descriptor.usesOptimisticLocking() && descriptor.getOptimisticLockingPolicy().isChildWriteLockValueGreater(unitOfWork, primaryKey, original.getClass())) {
                    cacheKey.setWriteLockValue(unitOfWork.getIdentityMapAccessor().getWriteLockValue(original));
                }
                cacheKey.setObject(original);
                if (descriptor.getCacheInvalidationPolicy().shouldUpdateReadTimeOnUpdate() || objectChangeSet != null && objectChangeSet.isNew()) {
                    cacheKey.setReadTime(this.getSystemTime());
                }
            }
            finally {
                cacheKey.updateAccess();
                cacheKey.release();
            }
        }
        return clone;
    }

    public void mergeCloneIntoWorkingCopy() {
        this.setMergePolicy(3);
    }

    public void mergeCloneWithReferencesIntoWorkingCopy() {
        this.setMergePolicy(7);
    }

    public void mergeIntoDistributedCache() {
        this.setMergePolicy(6);
    }

    public Object mergeNewObjectIntoCache(ObjectChangeSet changeSet) {
        if (changeSet.isNew()) {
            Class objectClass = changeSet.getClassType(this.session);
            ClassDescriptor descriptor = this.getSession().getDescriptor(objectClass);
            Object object = changeSet.getTargetVersionOfSourceObject(this.getSession(), false);
            if (object == null) {
                if (!this.getObjectsAlreadyMerged().containsKey(changeSet)) {
                    object = descriptor.getObjectBuilder().buildNewInstance();
                    this.getObjectsAlreadyMerged().put(changeSet, object);
                } else {
                    object = this.getObjectsAlreadyMerged().get(changeSet);
                }
            } else {
                object = changeSet.getTargetVersionOfSourceObject(this.getSession(), true);
            }
            this.mergeChanges(object, changeSet);
            Object implementation = descriptor.getObjectBuilder().unwrapObject(object, this.getSession());
            return this.getSession().getIdentityMapAccessorInstance().putInIdentityMap(implementation, descriptor.getObjectBuilder().extractPrimaryKeyFromObject(implementation, this.getSession()), changeSet.getWriteLockValue(), this.getSystemTime(), descriptor);
        }
        return null;
    }

    public void mergeOriginalIntoWorkingCopy() {
        this.setMergePolicy(2);
    }

    public void mergeWorkingCopyIntoBackup() {
        this.setMergePolicy(9);
    }

    public void mergeWorkingCopyIntoOriginal() {
        this.setMergePolicy(1);
    }

    public void mergeWorkingCopyIntoRemote() {
        this.setMergePolicy(4);
    }

    public void refreshRemoteObject() {
        this.setMergePolicy(5);
    }

    protected Object registerObjectForMergeCloneIntoWorkingCopy(Object clone) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(clone.getClass());
        Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(clone, this.getSession());
        Object objectFromCache = this.getSession().getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, descriptor.getJavaClass(), descriptor, null);
        if (objectFromCache != null) {
            return objectFromCache;
        }
        DoesExistQuery existQuery = descriptor.getQueryManager().getDoesExistQuery();
        if (existQuery.shouldCheckCacheForDoesExist()) {
            return ((UnitOfWorkImpl)this.getSession()).internalRegisterObject(clone, descriptor);
        }
        Boolean doesExist = (Boolean)existQuery.checkEarlyReturn(clone, primaryKey, this.getSession(), null);
        if (doesExist == Boolean.FALSE) {
            Object registeredObject = ((UnitOfWorkImpl)this.getSession()).internalRegisterObject(clone, descriptor);
            this.mergedNewObjects.put(registeredObject, registeredObject);
            return registeredObject;
        }
        Object object = this.getSession().readObject(clone);
        if (object == null) {
            return ((UnitOfWorkImpl)this.getSession()).internalRegisterObject(clone, descriptor);
        }
        return object;
    }

    public void registerRemovedNewObjectIfRequired(Object removedObject) {
        if (this.getSession().isUnitOfWork()) {
            UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.getSession();
            if (this.shouldMergeWorkingCopyIntoOriginal() && unitOfWork.getParent().isUnitOfWork() && unitOfWork.isCloneNewObject(removedObject)) {
                Object originalVersionOfRemovedObject = unitOfWork.getOriginalVersionOfObject(removedObject);
                unitOfWork.addRemovedObject(originalVersionOfRemovedObject);
            }
        }
    }

    public void setCascadePolicy(int cascadePolicy) {
        this.cascadePolicy = cascadePolicy;
    }

    protected void setMergePolicy(int mergePolicy) {
        this.mergePolicy = mergePolicy;
    }

    public void setForceCascade(boolean forceCascade) {
        this.forceCascade = forceCascade;
    }

    public void setObjectDescriptors(IdentityHashtable objectDescriptors) {
        this.objectDescriptors = objectDescriptors;
    }

    protected void setObjectsAlreadyMerged(IdentityHashtable objectsAlreadyMerged) {
        this.objectsAlreadyMerged = objectsAlreadyMerged;
    }

    public void setQueueNode(LinkedNode node) {
        this.queueNode = node;
    }

    protected void setSession(AbstractSession session) {
        this.session = session;
    }

    public void setWriteLockQueued(CacheKey writeLockQueued) {
        this.writeLockQueued = writeLockQueued;
    }

    public boolean shouldCascadeByMapping() {
        return this.getCascadePolicy() == 4;
    }

    public boolean shouldCascadeAllParts() {
        return this.getCascadePolicy() == 3;
    }

    public boolean shouldCascadeParts() {
        return this.getCascadePolicy() != 1;
    }

    public boolean shouldCascadePrivateParts() {
        return this.getCascadePolicy() == 2 || this.getCascadePolicy() == 3;
    }

    public boolean shouldCascadeReferences() {
        return !this.shouldMergeCloneIntoWorkingCopy();
    }

    public boolean shouldMergeChangesIntoDistributedCache() {
        return this.getMergePolicy() == 6;
    }

    public boolean shouldMergeCloneIntoWorkingCopy() {
        return this.getMergePolicy() == 3;
    }

    public boolean shouldMergeCloneWithReferencesIntoWorkingCopy() {
        return this.getMergePolicy() == 7;
    }

    public boolean shouldMergeOriginalIntoWorkingCopy() {
        return this.getMergePolicy() == 2;
    }

    public boolean shouldMergeWorkingCopyIntoBackup() {
        return this.getMergePolicy() == 9;
    }

    public boolean shouldMergeWorkingCopyIntoOriginal() {
        return this.getMergePolicy() == 1;
    }

    public boolean shouldMergeWorkingCopyIntoRemote() {
        return this.getMergePolicy() == 4;
    }

    public boolean shouldRefreshRemoteObject() {
        return this.getMergePolicy() == 5;
    }

    public boolean shouldForceCascade() {
        return this.forceCascade;
    }
}

